/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import java.util.Objects;

public final class PartitionKeyRangeIdentity {
    private final String collectionRid;
    private final String partitionKeyRangeId;

    public PartitionKeyRangeIdentity(String collectionRid, String partitionKeyRangeId) {
        if (collectionRid == null) {
            throw new IllegalArgumentException("collectionRid");
        }
        if (partitionKeyRangeId == null) {
            throw new IllegalArgumentException("partitionKeyRangeId");
        }
        this.collectionRid = collectionRid;
        this.partitionKeyRangeId = partitionKeyRangeId;
    }

    public PartitionKeyRangeIdentity(String partitionKeyRangeId) {
        if (partitionKeyRangeId == null) {
            throw new IllegalArgumentException("partitionKeyRangeId");
        }
        this.collectionRid = null;
        this.partitionKeyRangeId = partitionKeyRangeId;
    }

    public static PartitionKeyRangeIdentity fromHeader(String header) {
        String[] parts = StringUtils.split(header, ",");
        if (parts.length == 2) {
            return new PartitionKeyRangeIdentity(parts[0], parts[1]);
        }
        if (parts.length == 1) {
            return new PartitionKeyRangeIdentity(parts[0]);
        }
        throw new IllegalStateException("x-ms-documentdb-partitionkeyrangeid header contains invalid value '" + header + "'");
    }

    public String toHeader() {
        if (this.collectionRid != null) {
            return this.collectionRid + "," + this.partitionKeyRangeId;
        }
        return this.partitionKeyRangeId;
    }

    public String toString() {
        return "PartitionKeyRangeIdentity{collectionRid='" + this.collectionRid + '\'' + ", partitionKeyRangeId='" + this.partitionKeyRangeId + '\'' + '}';
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PartitionKeyRangeIdentity that = (PartitionKeyRangeIdentity)other;
        if (!Objects.equals(this.collectionRid, that.collectionRid)) {
            return false;
        }
        return this.partitionKeyRangeId.equals(that.partitionKeyRangeId);
    }

    public int hashCode() {
        int result = this.collectionRid != null ? this.collectionRid.hashCode() : 0;
        result = 397 * result ^ this.partitionKeyRangeId.hashCode();
        return result;
    }

    public String getCollectionRid() {
        return this.collectionRid;
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }
}

