/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.controller.request;

import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.implementation.throughputControl.ThroughputRequestThrottler;
import com.azure.cosmos.implementation.throughputControl.controller.request.IThroughputRequestController;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class PkRangesThroughputRequestController
implements IThroughputRequestController {
    private static final Logger logger = LoggerFactory.getLogger(PkRangesThroughputRequestController.class);
    private static final Range<String> RANGE_INCLUDING_ALL_PARTITION_KEY_RANGES = new Range<String>(PartitionKeyInternalHelper.MinimumInclusiveEffectivePartitionKey, PartitionKeyInternalHelper.MaximumExclusiveEffectivePartitionKey, true, false);
    private final RxPartitionKeyRangeCache partitionKeyRangeCache;
    private final ConcurrentHashMap<String, ThroughputRequestThrottler> requestThrottlerMap;
    private final String targetContainerRid;
    private double scheduledThroughput;
    private List<PartitionKeyRange> pkRanges;

    public PkRangesThroughputRequestController(RxPartitionKeyRangeCache partitionKeyRangeCache, String targetContainerRid, double initialScheduledThroughput) {
        Preconditions.checkNotNull(partitionKeyRangeCache, "RxPartitionKeyRangeCache can not be null");
        Preconditions.checkArgument(StringUtils.isNotEmpty(targetContainerRid), "Target container rid can not be null nor empty");
        this.partitionKeyRangeCache = partitionKeyRangeCache;
        this.requestThrottlerMap = new ConcurrentHashMap();
        this.targetContainerRid = targetContainerRid;
        this.scheduledThroughput = initialScheduledThroughput;
    }

    @Override
    public double renewThroughputUsageCycle(double scheduledThroughput) {
        this.scheduledThroughput = scheduledThroughput;
        double throughputPerPkRange = this.calculateThroughputPerPkRange();
        return this.requestThrottlerMap.values().stream().map(requestThrottler -> requestThrottler.renewThroughputUsageCycle(throughputPerPkRange)).max(Comparator.naturalOrder()).get();
    }

    @Override
    public boolean canHandleRequest(RxDocumentServiceRequest request) {
        PartitionKeyRange resolvedPkRange;
        if (request.requestContext != null && (resolvedPkRange = request.requestContext.resolvedPartitionKeyRange) != null) {
            return this.pkRanges.contains(resolvedPkRange);
        }
        return false;
    }

    @Override
    public <T> Mono<T> init() {
        return this.getPartitionKeyRanges(RANGE_INCLUDING_ALL_PARTITION_KEY_RANGES).doOnSuccess(pkRanges -> {
            this.pkRanges = pkRanges;
            this.createRequestThrottlers();
        }).then(Mono.just((Object)this));
    }

    private void createRequestThrottlers() {
        double throughputPerPkRange = this.calculateThroughputPerPkRange();
        for (PartitionKeyRange pkRange : this.pkRanges) {
            this.requestThrottlerMap.compute(pkRange.getId(), (pkRangeId, requestThrottler) -> {
                if (requestThrottler == null) {
                    requestThrottler = new ThroughputRequestThrottler(throughputPerPkRange, (String)pkRangeId);
                }
                return requestThrottler;
            });
        }
    }

    @Override
    public <T> Mono<T> processRequest(RxDocumentServiceRequest request, Mono<T> nextRequestMono) {
        PartitionKeyRange resolvedPkRange = request.requestContext.resolvedPartitionKeyRange;
        ThroughputRequestThrottler requestThrottler = this.requestThrottlerMap.get(resolvedPkRange.getId());
        if (requestThrottler != null) {
            return requestThrottler.processRequest(request, nextRequestMono);
        }
        logger.warn("Can not find matching request throttler to process request {} with pkRangeId {}", (Object)request.getActivityId(), (Object)resolvedPkRange.getId());
        return nextRequestMono;
    }

    private double calculateThroughputPerPkRange() {
        Preconditions.checkArgument(this.pkRanges != null && this.pkRanges.size() > 0, "Pk range count can not be 0");
        return this.scheduledThroughput / (double)this.pkRanges.size();
    }

    private Mono<List<PartitionKeyRange>> getPartitionKeyRanges(Range<String> range) {
        Preconditions.checkNotNull(range, "Range can not be null");
        return this.partitionKeyRangeCache.tryGetOverlappingRangesAsync(null, this.targetContainerRid, range, true, null).map(partitionKeyRangesValueHolder -> (List)partitionKeyRangesValueHolder.v);
    }
}

