/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;

public final class UniqueKey {
    private List<String> paths;
    private JsonSerializable jsonSerializable;

    public UniqueKey(List<String> paths) {
        this.jsonSerializable = new JsonSerializable();
        this.paths = paths;
    }

    UniqueKey(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    UniqueKey(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    public List<String> getPaths() {
        if (this.paths == null) {
            this.paths = this.jsonSerializable.getList("paths", String.class, new boolean[0]);
            if (this.paths == null) {
                this.paths = new ArrayList<String>();
            }
        }
        return this.paths;
    }

    public UniqueKey setPaths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
        if (this.paths != null) {
            this.jsonSerializable.set("paths", this.paths, CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

