/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.PartitionKeyBasedBloomFilter;
import com.azure.cosmos.implementation.PartitionScopedRegionLevelProgress;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.VectorSessionToken;
import com.azure.cosmos.implementation.apachecommons.collections.map.UnmodifiableMap;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTokenHelper {
    private static final Logger logger = LoggerFactory.getLogger(SessionTokenHelper.class);

    public static void setOriginalSessionToken(RxDocumentServiceRequest request, String originalSessionToken) {
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (originalSessionToken == null) {
            request.getHeaders().remove("x-ms-session-token");
        } else {
            request.getHeaders().put("x-ms-session-token", originalSessionToken);
        }
    }

    public static void setPartitionLocalSessionToken(RxDocumentServiceRequest request, ISessionContainer sessionContainer) {
        SessionTokenHelper.setPartitionLocalSessionToken(request, request.requestContext.resolvedPartitionKeyRange.getId(), sessionContainer);
    }

    public static void setPartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId, ISessionContainer sessionContainer) {
        ISessionToken sessionToken;
        String originalSessionToken = request.getHeaders().get("x-ms-session-token");
        if (Strings.isNullOrEmpty(partitionKeyRangeId)) {
            throw new InternalServerErrorException(Exceptions.getInternalServerErrorMessage("PartitionKeyRangeId is absent in the context."), 20902);
        }
        request.requestContext.sessionToken = StringUtils.isNotEmpty(originalSessionToken) ? (sessionToken = SessionTokenHelper.getLocalSessionToken(request, originalSessionToken, partitionKeyRangeId)) : (sessionToken = sessionContainer.resolvePartitionLocalSessionToken(request, partitionKeyRangeId));
        if (request.requestContext.sessionToken == null) {
            request.getHeaders().remove("x-ms-session-token");
        } else {
            request.getHeaders().put("x-ms-session-token", SessionTokenHelper.concatPartitionKeyRangeIdWithSessionToken(partitionKeyRangeId, request.requestContext.sessionToken.convertToString()));
        }
    }

    private static ISessionToken getLocalSessionToken(RxDocumentServiceRequest request, String globalSessionToken, String partitionKeyRangeId) {
        if (partitionKeyRangeId == null) {
            throw new IllegalStateException("Partition key range Id is absent in the context.");
        }
        String[] localTokens = StringUtils.split(globalSessionToken, ",");
        HashSet<String> partitionKeyRangeSet = new HashSet<String>();
        partitionKeyRangeSet.add(partitionKeyRangeId);
        ISessionToken highestSessionToken = null;
        if (request.requestContext.resolvedPartitionKeyRange != null && request.requestContext.resolvedPartitionKeyRange.getParents() != null) {
            partitionKeyRangeSet.addAll(request.requestContext.resolvedPartitionKeyRange.getParents());
        }
        for (String localToken : localTokens) {
            String[] items = StringUtils.split(localToken, ":");
            if (items.length != 2) {
                throw new BadRequestException(String.format("The session token provided '%s' is invalid.", partitionKeyRangeId));
            }
            ISessionToken parsedSessionToken = SessionTokenHelper.parse(items[1]);
            if (!partitionKeyRangeSet.contains(items[0])) continue;
            highestSessionToken = highestSessionToken == null ? parsedSessionToken : highestSessionToken.merge(parsedSessionToken);
        }
        if (highestSessionToken == null && StringUtils.isNotEmpty(globalSessionToken)) {
            Set<String> sessionTokenEvaluationResults = request.requestContext.getSessionTokenEvaluationResults();
            String evaluationResult = "The session token : " + globalSessionToken + " for pkRangeId : " + partitionKeyRangeId + " and collectionRid : " + request.requestContext.resolvedCollectionRid + " could not be evaluated, the request will fallback to eventual consistency.";
            sessionTokenEvaluationResults.add(evaluationResult);
            if (Configs.shouldLogIncorrectlyMappedSessionToken()) {
                logger.warn(evaluationResult);
            }
        }
        return highestSessionToken;
    }

    static ISessionToken resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId, ConcurrentHashMap<String, ISessionToken> rangeIdToTokenMap) {
        if (rangeIdToTokenMap != null) {
            if (rangeIdToTokenMap.containsKey(partitionKeyRangeId)) {
                return rangeIdToTokenMap.get(partitionKeyRangeId);
            }
            ISessionToken parentSessionToken = null;
            List<String> parents = request.requestContext.resolvedPartitionKeyRange.getParents();
            if (parents != null && !parents.isEmpty()) {
                ArrayList<String> parentsList = new ArrayList<String>(parents);
                for (int i = parentsList.size() - 1; i >= 0; --i) {
                    String parentId = (String)parentsList.get(i);
                    if (!rangeIdToTokenMap.containsKey(parentId)) continue;
                    parentSessionToken = parentSessionToken != null ? parentSessionToken.merge(rangeIdToTokenMap.get(parentId)) : rangeIdToTokenMap.get(parentId);
                }
                return parentSessionToken;
            }
        }
        return null;
    }

    static ISessionToken resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, PartitionKeyBasedBloomFilter partitionKeyBasedBloomFilter, PartitionScopedRegionLevelProgress partitionScopedRegionLevelProgress, PartitionKeyInternal partitionKey, PartitionKeyDefinition partitionKeyDefinition, Long collectionRid, String partitionKeyRangeId, String firstEffectivePreferredReadableRegion, boolean canUseBloomFilter) {
        if (partitionScopedRegionLevelProgress != null) {
            Set<String> partitionKeyPossibleRegions = new HashSet<String>();
            if (partitionScopedRegionLevelProgress.isPartitionKeyRangeIdPresent(partitionKeyRangeId)) {
                if (canUseBloomFilter) {
                    partitionKeyPossibleRegions = partitionKeyBasedBloomFilter.tryGetPossibleRegionsLogicalPartitionResolvedTo(request, collectionRid, partitionKey, partitionKeyDefinition);
                    return partitionScopedRegionLevelProgress.tryResolveSessionToken(request, partitionKeyPossibleRegions, partitionKeyRangeId, firstEffectivePreferredReadableRegion, true);
                }
                return partitionScopedRegionLevelProgress.tryResolveSessionToken(request, partitionKeyPossibleRegions, partitionKeyRangeId, firstEffectivePreferredReadableRegion, false);
            }
            if (canUseBloomFilter) {
                partitionKeyPossibleRegions = partitionKeyBasedBloomFilter.tryGetPossibleRegionsLogicalPartitionResolvedTo(request, collectionRid, partitionKey, partitionKeyDefinition);
            }
            ISessionToken parentSessionToken = null;
            List<String> parents = request.requestContext.resolvedPartitionKeyRange.getParents();
            if (parents != null && !parents.isEmpty()) {
                ArrayList<String> parentsList = new ArrayList<String>(parents);
                for (int i = parentsList.size() - 1; i >= 0; --i) {
                    String parentPkRangeId = (String)parentsList.get(i);
                    if (!partitionScopedRegionLevelProgress.isPartitionKeyRangeIdPresent(parentPkRangeId)) continue;
                    ISessionToken resolvedSessionTokenForParentPkRangeId = null;
                    resolvedSessionTokenForParentPkRangeId = partitionScopedRegionLevelProgress.tryResolveSessionToken(request, partitionKeyPossibleRegions, parentPkRangeId, firstEffectivePreferredReadableRegion, canUseBloomFilter);
                    if (resolvedSessionTokenForParentPkRangeId == null) continue;
                    parentSessionToken = parentSessionToken != null ? parentSessionToken.merge(resolvedSessionTokenForParentPkRangeId) : resolvedSessionTokenForParentPkRangeId;
                }
                return parentSessionToken;
            }
        }
        return null;
    }

    public static ISessionToken parse(String sessionToken) {
        Utils.ValueHolder<Object> partitionKeyRangeSessionToken = Utils.ValueHolder.initialize(null);
        if (SessionTokenHelper.tryParse(sessionToken, partitionKeyRangeSessionToken)) {
            return (ISessionToken)partitionKeyRangeSessionToken.v;
        }
        throw new RuntimeException((Throwable)((Object)new BadRequestException(String.format("The session token provided '%s' is invalid.", sessionToken))));
    }

    static boolean tryParse(String sessionToken, Utils.ValueHolder<ISessionToken> parsedSessionToken) {
        parsedSessionToken.v = null;
        if (!Strings.isNullOrEmpty(sessionToken)) {
            String[] sessionTokenSegments = StringUtils.split(sessionToken, ":");
            return VectorSessionToken.tryCreate(sessionTokenSegments[sessionTokenSegments.length - 1], parsedSessionToken);
        }
        return false;
    }

    public static void validateAndRemoveSessionToken(RxDocumentServiceRequest request) {
        String sessionToken = request.getHeaders().get("x-ms-session-token");
        if (!Strings.isNullOrEmpty(sessionToken)) {
            SessionTokenHelper.getLocalSessionToken(request, sessionToken, "");
            request.getHeaders().remove("x-ms-session-token");
        }
    }

    public static String concatPartitionKeyRangeIdWithSessionToken(String partitionKeyRangeRid, String sessionToken) {
        return partitionKeyRangeRid + ":" + sessionToken;
    }

    public static boolean tryEvaluateLocalLsnByRegionMappingWithNullSafety(ISessionToken sessionToken, Utils.ValueHolder<UnmodifiableMap<Integer, Long>> localLsnByRegion) {
        if (sessionToken instanceof VectorSessionToken) {
            VectorSessionToken castVectorSessionToken = Utils.as(sessionToken, VectorSessionToken.class);
            localLsnByRegion.v = castVectorSessionToken.getLocalLsnByRegion();
            return localLsnByRegion.v != null;
        }
        return false;
    }

    public static boolean tryEvaluateVersion(ISessionToken sessionToken, Utils.ValueHolder<Long> version) {
        if (sessionToken instanceof VectorSessionToken) {
            VectorSessionToken castVectorSessionToken = Utils.as(sessionToken, VectorSessionToken.class);
            version.v = castVectorSessionToken.getVersion();
            return true;
        }
        return false;
    }
}

