/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import java.net.URI;
import java.util.Map;

public class UnauthorizedException
extends CosmosException {
    UnauthorizedException() {
        this("Unable to authenticate the request. The request requires valid user authentication.");
    }

    public UnauthorizedException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(401, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    UnauthorizedException(String message) {
        this(message, null, null, null);
    }

    UnauthorizedException(String message, HttpHeaders headers, String requestUriString) {
        this(message, null, headers, requestUriString);
    }

    public UnauthorizedException(String message, HttpHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    UnauthorizedException(Exception innerException) {
        this("Unable to authenticate the request. The request requires valid user authentication.", innerException, null, null);
    }

    UnauthorizedException(String message, Exception innerException, HttpHeaders headers, String requestUri) {
        super(String.format("%s: %s", "Unable to authenticate the request. The request requires valid user authentication.", message), innerException, HttpUtils.asMap(headers), 401, requestUri);
    }
}

