/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.common;

import com.azure.cosmos.ChangeFeedProcessorContext;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserver;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverCloseReason;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverContext;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedProcessorContextImpl;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class DefaultObserver<T>
implements ChangeFeedObserver<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultObserver.class);
    private final Consumer<List<T>> consumer;
    private final BiConsumer<List<T>, ChangeFeedProcessorContext> biConsumer;

    public DefaultObserver(Consumer<List<T>> consumer) {
        this.consumer = consumer;
        this.biConsumer = null;
    }

    public DefaultObserver(BiConsumer<List<T>, ChangeFeedProcessorContext> biConsumer) {
        this.biConsumer = biConsumer;
        this.consumer = null;
    }

    @Override
    public void open(ChangeFeedObserverContext<T> context) {
        log.info("Open processing from thread {}", (Object)Thread.currentThread().getId());
    }

    @Override
    public void close(ChangeFeedObserverContext<T> context, ChangeFeedObserverCloseReason reason) {
        log.info("Close processing from thread {}", (Object)Thread.currentThread().getId());
    }

    @Override
    public Mono<Void> processChanges(ChangeFeedObserverContext<T> context, List<T> docs) {
        log.info("Start processing from thread {}", (Object)Thread.currentThread().getId());
        try {
            if (this.consumer != null) {
                this.consumer.accept(docs);
            } else if (this.biConsumer != null) {
                this.biConsumer.accept(docs, new ChangeFeedProcessorContextImpl<T>(context));
            }
            log.info("Done processing from thread {}", (Object)Thread.currentThread().getId());
        }
        catch (Exception ex) {
            log.warn("Unexpected exception thrown from thread {}", (Object)Thread.currentThread().getId(), (Object)ex);
            return Mono.error((Throwable)ex);
        }
        return Mono.empty();
    }
}

