/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.addressEnumerator;

import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AddressEnumeratorUsingPermutations {
    private static AtomicReference<List<List<List<Integer>>>> allPermutations = new AtomicReference<Object>(null);

    public static List<Uri> getTransportAddressUris(List<Uri> addresses) {
        Preconditions.checkNotNull(addresses, "Argument 'addresses' should not be null");
        List<List<Integer>> allPermutationsForSpecificSize = allPermutations.get().get(addresses.size());
        int permutation = AddressEnumeratorUsingPermutations.generateNextRandom(allPermutationsForSpecificSize.size());
        ArrayList<Uri> addressList = new ArrayList<Uri>();
        for (int index : allPermutationsForSpecificSize.get(permutation)) {
            addressList.add(addresses.get(index));
        }
        return addressList;
    }

    public static boolean isSizeInPermutationLimits(int size) {
        return size < allPermutations.get().size();
    }

    private static void permuteIndexPositions(int[] array, int start, int length, List<List<Integer>> output) {
        if (start == length) {
            output.add(Arrays.stream(array).boxed().collect(Collectors.toList()));
        } else {
            for (int j = start; j < length; ++j) {
                AddressEnumeratorUsingPermutations.swap(array, start, j);
                AddressEnumeratorUsingPermutations.permuteIndexPositions(array, start + 1, length, output);
                AddressEnumeratorUsingPermutations.swap(array, start, j);
            }
        }
    }

    private static void swap(int[] array, int leftIndex, int rightIndex) {
        int tmp = array[leftIndex];
        array[leftIndex] = array[rightIndex];
        array[rightIndex] = tmp;
    }

    private static int generateNextRandom(int maxValue) {
        return ThreadLocalRandom.current().nextInt(maxValue);
    }

    static {
        if (allPermutations.compareAndSet(null, new ArrayList())) {
            for (int i = 0; i <= 6; ++i) {
                ArrayList<List<Integer>> permutations = new ArrayList<List<Integer>>();
                AddressEnumeratorUsingPermutations.permuteIndexPositions(IntStream.range(0, i).toArray(), 0, i, permutations);
                allPermutations.get().add(permutations);
            }
        }
    }
}

