/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.faultinjection;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.faultinjection.FaultInjectionRequestArgs;
import com.azure.cosmos.implementation.faultinjection.GatewayFaultInjectionRequestArgs;
import com.azure.cosmos.implementation.faultinjection.IServerErrorInjector;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import com.azure.cosmos.implementation.http.ReactorNettyRequestRecord;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import io.netty.channel.ConnectTimeoutException;
import io.netty.handler.timeout.ReadTimeoutException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import reactor.core.publisher.Mono;

public class GatewayServerErrorInjector {
    private final Configs configs;
    private final RxCollectionCache collectionCache;
    private final RxPartitionKeyRangeCache partitionKeyRangeCache;
    private List<IServerErrorInjector> faultInjectors = new ArrayList<IServerErrorInjector>();

    public GatewayServerErrorInjector(Configs configs, RxCollectionCache collectionCache, RxPartitionKeyRangeCache partitionKeyRangeCache) {
        Preconditions.checkNotNull(configs, "Argument 'configs' can not be null");
        this.configs = configs;
        this.collectionCache = collectionCache;
        this.partitionKeyRangeCache = partitionKeyRangeCache;
    }

    public GatewayServerErrorInjector(Configs configs) {
        this(configs, null, null);
    }

    public void registerServerErrorInjector(IServerErrorInjector serverErrorInjector) {
        Preconditions.checkNotNull(serverErrorInjector, "Argument 'serverErrorInjector' can not be null");
        this.faultInjectors.add(serverErrorInjector);
    }

    private Mono<Utils.ValueHolder<PartitionKeyRange>> resolvePartitionKeyRange(RxDocumentServiceRequest request) {
        if (request.getResourceType() != ResourceType.Document) {
            return Mono.just(Utils.ValueHolder.initialize(null));
        }
        if (this.collectionCache == null || this.partitionKeyRangeCache == null) {
            return Mono.just(Utils.ValueHolder.initialize(null));
        }
        if (request == null || request.requestContext == null) {
            return Mono.just(Utils.ValueHolder.initialize(null));
        }
        if (request.requestContext.resolvedPartitionKeyRange != null) {
            return Mono.just(Utils.ValueHolder.initialize(request.requestContext.resolvedPartitionKeyRange));
        }
        return this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request).flatMap(collectionValueHolder -> this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)collectionValueHolder.v).getResourceId(), null, null).flatMap(collectionRoutingMapValueHolder -> {
            String partitionKeyRangeId = request.getHeaders().get("x-ms-documentdb-partitionkeyrangeid");
            PartitionKeyInternal partitionKeyInternal = request.getPartitionKeyInternal();
            if (StringUtils.isNotEmpty(partitionKeyRangeId)) {
                PartitionKeyRange range;
                request.requestContext.resolvedPartitionKeyRange = range = ((CollectionRoutingMap)collectionRoutingMapValueHolder.v).getRangeByPartitionKeyRangeId(partitionKeyRangeId);
            } else if (partitionKeyInternal != null) {
                PartitionKeyRange range;
                String effectivePartitionKeyString = PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKeyInternal, ((DocumentCollection)collectionValueHolder.v).getPartitionKey());
                request.requestContext.resolvedPartitionKeyRange = range = ((CollectionRoutingMap)collectionRoutingMapValueHolder.v).getRangeByEffectivePartitionKey(effectivePartitionKeyString);
            }
            return Mono.just(Utils.ValueHolder.initialize(request.requestContext.resolvedPartitionKeyRange));
        }));
    }

    public Mono<HttpResponse> injectGatewayErrors(Duration responseTimeout, HttpRequest httpRequest, RxDocumentServiceRequest serviceRequest, Mono<HttpResponse> originalResponseMono) {
        return this.resolvePartitionKeyRange(serviceRequest).flatMap(resolvedPartitionKeyRangeValueHolder -> this.injectGatewayErrors(responseTimeout, httpRequest, serviceRequest, originalResponseMono, resolvedPartitionKeyRangeValueHolder.v == null ? null : Arrays.asList(((PartitionKeyRange)resolvedPartitionKeyRangeValueHolder.v).getId())));
    }

    public Mono<HttpResponse> injectGatewayErrors(Duration responseTimeout, HttpRequest httpRequest, RxDocumentServiceRequest serviceRequest, Mono<HttpResponse> originalResponseMono, List<String> partitionKeyRangeIds) {
        return Mono.just((Object)responseTimeout).flatMap(effectiveResponseTimeout -> {
            Utils.ValueHolder<CosmosException> exceptionToBeInjected = new Utils.ValueHolder<CosmosException>();
            Utils.ValueHolder<Duration> delayToBeInjected = new Utils.ValueHolder<Duration>();
            GatewayFaultInjectionRequestArgs faultInjectionRequestArgs = this.createFaultInjectionRequestArgs(httpRequest.reactorNettyRequestRecord(), httpRequest.uri(), serviceRequest, partitionKeyRangeIds);
            if (this.injectGatewayServerResponseError(faultInjectionRequestArgs, exceptionToBeInjected)) {
                return Mono.error((Throwable)((Throwable)exceptionToBeInjected.v));
            }
            if (this.injectGatewayServerConnectionDelay(faultInjectionRequestArgs, delayToBeInjected)) {
                Duration connectionAcquireTimeout = Configs.getConnectionAcquireTimeout();
                if (((Duration)delayToBeInjected.v).toMillis() >= connectionAcquireTimeout.toMillis()) {
                    return Mono.delay((Duration)connectionAcquireTimeout).then(Mono.error((Throwable)new ConnectTimeoutException()));
                }
                return Mono.delay((Duration)((Duration)delayToBeInjected.v)).then(originalResponseMono);
            }
            if (this.injectGatewayServerResponseDelayBeforeProcessing(faultInjectionRequestArgs, delayToBeInjected)) {
                if (((Duration)delayToBeInjected.v).toMillis() >= effectiveResponseTimeout.toMillis()) {
                    return Mono.delay((Duration)effectiveResponseTimeout).then(Mono.error((Throwable)new ReadTimeoutException()));
                }
                return Mono.delay((Duration)((Duration)delayToBeInjected.v)).then(originalResponseMono);
            }
            if (this.injectGatewayServerResponseDelayAfterProcessing(faultInjectionRequestArgs, delayToBeInjected)) {
                if (((Duration)delayToBeInjected.v).toMillis() >= effectiveResponseTimeout.toMillis()) {
                    return originalResponseMono.delayElement((Duration)delayToBeInjected.v).then(Mono.error((Throwable)new ReadTimeoutException()));
                }
                return originalResponseMono.delayElement((Duration)delayToBeInjected.v);
            }
            return originalResponseMono;
        });
    }

    private boolean injectGatewayServerResponseDelayBeforeProcessing(FaultInjectionRequestArgs faultInjectionRequestArgs, Utils.ValueHolder<Duration> delayToBeInjected) {
        for (IServerErrorInjector serverErrorInjector : this.faultInjectors) {
            if (!serverErrorInjector.injectServerResponseDelayBeforeProcessing(faultInjectionRequestArgs, delayToBeInjected)) continue;
            return true;
        }
        return false;
    }

    private boolean injectGatewayServerResponseDelayAfterProcessing(FaultInjectionRequestArgs faultInjectionRequestArgs, Utils.ValueHolder<Duration> delayToBeInjected) {
        for (IServerErrorInjector serverErrorInjector : this.faultInjectors) {
            if (!serverErrorInjector.injectServerResponseDelayAfterProcessing(faultInjectionRequestArgs, delayToBeInjected)) continue;
            return true;
        }
        return false;
    }

    private boolean injectGatewayServerResponseError(FaultInjectionRequestArgs faultInjectionRequestArgs, Utils.ValueHolder<CosmosException> exceptionToBeInjected) {
        for (IServerErrorInjector serverErrorInjector : this.faultInjectors) {
            if (!serverErrorInjector.injectServerResponseError(faultInjectionRequestArgs, exceptionToBeInjected)) continue;
            return true;
        }
        return false;
    }

    private boolean injectGatewayServerConnectionDelay(FaultInjectionRequestArgs faultInjectionRequestArgs, Utils.ValueHolder<Duration> delayToBeInjected) {
        for (IServerErrorInjector serverErrorInjector : this.faultInjectors) {
            if (!serverErrorInjector.injectServerConnectionDelay(faultInjectionRequestArgs, delayToBeInjected)) continue;
            return true;
        }
        return false;
    }

    private GatewayFaultInjectionRequestArgs createFaultInjectionRequestArgs(ReactorNettyRequestRecord requestRecord, URI requestUri, RxDocumentServiceRequest serviceRequest, List<String> partitionKeyRangeIds) {
        return new GatewayFaultInjectionRequestArgs(requestRecord.getTransportRequestId(), requestUri, serviceRequest, partitionKeyRangeIds);
    }
}

