/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.routing.UInt128;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistinctContinuationToken
extends JsonSerializable {
    private static final String LAST_HASH_PROPERTY_NAME = "lastHash";
    private static final String SOURCE_TOKEN_PROPERTY_NAME = "sourceToken";
    private static final Logger logger = LoggerFactory.getLogger(DistinctContinuationToken.class);

    public DistinctContinuationToken(UInt128 lastHash, String sourceToken) {
        this.setLastHash(lastHash);
        this.setSourceToken(sourceToken);
    }

    private DistinctContinuationToken(String serializedDistinctContinuationToken) {
        super(serializedDistinctContinuationToken);
    }

    public static boolean tryParse(String serializedDistinctContinuationToken, Utils.ValueHolder<DistinctContinuationToken> outDistinctContinuationToken) {
        boolean parsed;
        try {
            DistinctContinuationToken distinctContinuationToken = new DistinctContinuationToken(serializedDistinctContinuationToken);
            distinctContinuationToken.getSourceToken();
            distinctContinuationToken.getLastHash();
            outDistinctContinuationToken.v = distinctContinuationToken;
            parsed = true;
        }
        catch (Exception ex) {
            logger.debug("Received exception {} when trying to parse: {}", (Object)ex.getMessage(), (Object)serializedDistinctContinuationToken);
            parsed = false;
            outDistinctContinuationToken.v = null;
        }
        return parsed;
    }

    String getSourceToken() {
        return super.getString(SOURCE_TOKEN_PROPERTY_NAME);
    }

    public void setSourceToken(String sourceToken) {
        this.set(SOURCE_TOKEN_PROPERTY_NAME, sourceToken, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    UInt128 getLastHash() {
        ByteBuffer byteBuffer = super.getObject(LAST_HASH_PROPERTY_NAME, ByteBuffer.class, new boolean[0]);
        if (byteBuffer != null) {
            return new UInt128(byteBuffer);
        }
        return null;
    }

    public void setLastHash(UInt128 lastHash) {
        if (lastHash != null) {
            this.set(LAST_HASH_PROPERTY_NAME, lastHash.toByteBuffer().array(), CosmosItemSerializer.DEFAULT_SERIALIZER);
        } else {
            this.set(LAST_HASH_PROPERTY_NAME, null, CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
    }
}

