/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.clienttelemetry.MetricCategory;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;

public final class CosmosMetricCategory {
    private final String name;
    private final EnumSet<MetricCategory> metricCategories;
    public static final CosmosMetricCategory ALL = new CosmosMetricCategory("All", MetricCategory.ALL_CATEGORIES);
    public static final CosmosMetricCategory DEFAULT = new CosmosMetricCategory("Default", MetricCategory.DEFAULT_CATEGORIES);
    public static final CosmosMetricCategory MINIMUM = new CosmosMetricCategory("Minimum", EnumSet.of(MetricCategory.OperationSummary, MetricCategory.System));
    public static final CosmosMetricCategory OPERATION_SUMMARY = new CosmosMetricCategory("OperationSummary", EnumSet.of(MetricCategory.OperationSummary));
    public static final CosmosMetricCategory OPERATION_DETAILS = new CosmosMetricCategory("OperationDetails", EnumSet.of(MetricCategory.OperationDetails));
    public static final CosmosMetricCategory REQUEST_SUMMARY = new CosmosMetricCategory("RequestSummary", EnumSet.of(MetricCategory.RequestSummary));
    public static final CosmosMetricCategory REQUEST_DETAILS = new CosmosMetricCategory("RequestDetails", EnumSet.of(MetricCategory.RequestDetails));
    public static final CosmosMetricCategory DIRECT_ADDRESS_RESOLUTIONS = new CosmosMetricCategory("DirectAddressResolutions", EnumSet.of(MetricCategory.AddressResolutions));
    public static final CosmosMetricCategory DIRECT_CHANNELS = new CosmosMetricCategory("DirectChannels", EnumSet.of(MetricCategory.DirectChannels));
    public static final CosmosMetricCategory DIRECT_ENDPOINTS = new CosmosMetricCategory("DirectEndpoints", EnumSet.of(MetricCategory.DirectEndpoints));
    public static final CosmosMetricCategory DIRECT_REQUESTS = new CosmosMetricCategory("DirectRequests", EnumSet.of(MetricCategory.DirectRequests));
    public static final CosmosMetricCategory SYSTEM = new CosmosMetricCategory("System", EnumSet.of(MetricCategory.System));
    public static final CosmosMetricCategory LEGACY = new CosmosMetricCategory("Legacy", EnumSet.of(MetricCategory.Legacy));

    private CosmosMetricCategory(String name, EnumSet<MetricCategory> metricCategories) {
        Preconditions.checkNotNull(name, "Argument 'name' must not be null.");
        Preconditions.checkNotNull(metricCategories, "Argument 'metricCategories' must not be null.");
        this.name = name;
        this.metricCategories = metricCategories;
    }

    public static CosmosMetricCategory fromString(String name) {
        String normalizedName;
        Preconditions.checkNotNull(name, "Argument 'name' must not be null.");
        switch (normalizedName = name.trim().toLowerCase(Locale.ROOT)) {
            case "all": {
                return ALL;
            }
            case "default": {
                return DEFAULT;
            }
            case "minimum": {
                return MINIMUM;
            }
            case "operationsummary": {
                return OPERATION_SUMMARY;
            }
            case "operationdetails": {
                return OPERATION_DETAILS;
            }
            case "requestsummary": {
                return REQUEST_SUMMARY;
            }
            case "requestdetails": {
                return REQUEST_DETAILS;
            }
            case "directaddressresolutions": {
                return DIRECT_ADDRESS_RESOLUTIONS;
            }
            case "directchannels": {
                return DIRECT_CHANNELS;
            }
            case "directendpoints": {
                return DIRECT_ENDPOINTS;
            }
            case "directrequests": {
                return DIRECT_REQUESTS;
            }
            case "legacy": {
                return LEGACY;
            }
            case "system": {
                return SYSTEM;
            }
        }
        String errorMessage = String.format("Argument 'name' has invalid value '%s' - valid values are: %s", name, CosmosMetricCategory.getValidValues());
        throw new IllegalArgumentException(errorMessage);
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(CosmosMetricCategory.class, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!CosmosMetricCategory.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.name == null) {
            return ((CosmosMetricCategory)obj).name == null;
        }
        return this.name.equals(((CosmosMetricCategory)obj).name);
    }

    private static String getValidValues() {
        return new StringJoiner(", ").add(CosmosMetricCategory.ALL.name).add(CosmosMetricCategory.DEFAULT.name).add(CosmosMetricCategory.MINIMUM.name).add(CosmosMetricCategory.OPERATION_SUMMARY.name).add(CosmosMetricCategory.OPERATION_DETAILS.name).add(CosmosMetricCategory.REQUEST_SUMMARY.name).add(CosmosMetricCategory.REQUEST_DETAILS.name).add(CosmosMetricCategory.DIRECT_ADDRESS_RESOLUTIONS.name).add(CosmosMetricCategory.DIRECT_CHANNELS.name).add(CosmosMetricCategory.DIRECT_ENDPOINTS.name).add(CosmosMetricCategory.DIRECT_REQUESTS.name).add(CosmosMetricCategory.LEGACY.name).add(CosmosMetricCategory.SYSTEM.name).toString();
    }

    EnumSet<MetricCategory> getCategories() {
        return this.metricCategories;
    }
}

