/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.PartitionKeyDefinitionVersion;
import com.azure.cosmos.models.PartitionKind;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class PartitionKeyDefinition {
    private List<String> paths;
    private PartitionKind kind;
    private Optional<PartitionKeyDefinitionVersion> versionOptional;
    private Boolean systemKey;
    private JsonSerializable jsonSerializable;

    public PartitionKeyDefinition() {
        this.jsonSerializable = new JsonSerializable();
        this.setKind(PartitionKind.HASH);
    }

    PartitionKeyDefinition(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    PartitionKeyDefinition(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    public PartitionKind getKind() {
        if (this.kind == null) {
            this.kind = this.jsonSerializable.getObject("kind", PartitionKind.class, true);
        }
        return this.kind;
    }

    public PartitionKeyDefinition setKind(PartitionKind kind) {
        this.kind = kind;
        return this;
    }

    public PartitionKeyDefinitionVersion getVersion() {
        if (this.versionOptional == null) {
            Object versionObject = this.jsonSerializable.getObject("version", Object.class, new boolean[0]);
            if (versionObject == null) {
                this.versionOptional = Optional.empty();
            } else {
                String versionStr = String.valueOf(versionObject);
                if (StringUtils.isNumeric(versionStr)) {
                    this.versionOptional = Optional.of(PartitionKeyDefinitionVersion.valueOf(String.format("V%d", Integer.parseInt(versionStr))));
                } else {
                    Optional<Object> optional = this.versionOptional = !Strings.isNullOrEmpty(versionStr) ? Optional.of(PartitionKeyDefinitionVersion.valueOf(StringUtils.upperCase(versionStr))) : Optional.empty();
                }
            }
            assert (this.versionOptional != null);
        }
        return this.versionOptional.isPresent() ? this.versionOptional.get() : null;
    }

    public PartitionKeyDefinition setVersion(PartitionKeyDefinitionVersion version) {
        this.versionOptional = Optional.of(version);
        return this;
    }

    public List<String> getPaths() {
        if (this.paths == null) {
            this.paths = this.jsonSerializable.has("paths") ? this.jsonSerializable.getList("paths", String.class, new boolean[0]) : new ArrayList<String>();
        }
        return this.paths;
    }

    public PartitionKeyDefinition setPaths(List<String> paths) {
        if (paths == null || paths.size() == 0) {
            throw new IllegalArgumentException("getPaths must not be null or empty.");
        }
        this.paths = paths;
        return this;
    }

    Boolean isSystemKey() {
        if (this.systemKey == null) {
            this.systemKey = this.jsonSerializable.has("systemKey") ? this.jsonSerializable.getBoolean("systemKey") : Boolean.valueOf(false);
        }
        return this.systemKey;
    }

    PartitionKeyInternal getNonePartitionKeyValue() {
        if (this.getPaths().size() == 0 || this.isSystemKey().booleanValue()) {
            return PartitionKeyInternal.Empty;
        }
        return PartitionKeyInternal.UndefinedPartitionKey;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
        if (this.kind != null) {
            this.jsonSerializable.set("kind", this.kind.toString(), CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
        if (this.paths != null) {
            this.jsonSerializable.set("paths", this.paths, CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
        if (this.versionOptional != null && this.versionOptional.isPresent()) {
            this.jsonSerializable.set("version", this.versionOptional.get().toString(), CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

