/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.addressEnumerator;

import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.addressEnumerator.AddressEnumeratorFisherYateShuffle;
import com.azure.cosmos.implementation.directconnectivity.addressEnumerator.AddressEnumeratorUsingPermutations;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class AddressEnumerator {
    public static List<Uri> getTransportAddresses(RxDocumentServiceRequest request, List<Uri> addresses) {
        Preconditions.checkNotNull(addresses, "Argument 'addresses' should not be null");
        Preconditions.checkNotNull(request, "Argument 'request' should not be null");
        List<Uri> randomPermutation = AddressEnumerator.getAddressesPermutationInternal(addresses);
        return AddressEnumerator.sortAddresses(randomPermutation, request);
    }

    private static List<Uri> sortAddresses(List<Uri> addressesPermutation, final RxDocumentServiceRequest request) {
        if (!request.requestContext.replicaAddressValidationEnabled) {
            addressesPermutation.sort(new Comparator<Uri>(){

                @Override
                public int compare(Uri o1, Uri o2) {
                    Uri.HealthStatus o1Status = AddressEnumerator.getEffectiveStatus(o1, request.requestContext.getFailedEndpoints());
                    Uri.HealthStatus o2Status = AddressEnumerator.getEffectiveStatus(o2, request.requestContext.getFailedEndpoints());
                    if (o1Status != Uri.HealthStatus.Unhealthy && o2Status != Uri.HealthStatus.Unhealthy) {
                        return 0;
                    }
                    if (o1Status == Uri.HealthStatus.Unhealthy) {
                        return 1;
                    }
                    return -1;
                }
            });
        } else {
            addressesPermutation.sort(new Comparator<Uri>(){

                @Override
                public int compare(Uri o1, Uri o2) {
                    Uri.HealthStatus o2Status;
                    Uri.HealthStatus o1Status = AddressEnumerator.getEffectiveStatus(o1, request.requestContext.getFailedEndpoints());
                    if (o1Status == (o2Status = AddressEnumerator.getEffectiveStatus(o2, request.requestContext.getFailedEndpoints()))) {
                        return 0;
                    }
                    if (o1Status.getPriority() < Uri.HealthStatus.UnhealthyPending.getPriority() && o2Status.getPriority() < Uri.HealthStatus.UnhealthyPending.getPriority()) {
                        return 0;
                    }
                    return o1Status.getPriority() - o2Status.getPriority();
                }
            });
        }
        return addressesPermutation;
    }

    private static List<Uri> getAddressesPermutationInternal(List<Uri> addresses) {
        Preconditions.checkNotNull(addresses, "Argument 'addresses' should not be null");
        if (AddressEnumeratorUsingPermutations.isSizeInPermutationLimits(addresses.size())) {
            return AddressEnumeratorUsingPermutations.getTransportAddressUris(addresses);
        }
        return AddressEnumeratorFisherYateShuffle.getTransportAddressUris(addresses);
    }

    private static Uri.HealthStatus getEffectiveStatus(Uri addressUri, Set<Uri> failedEndpoints) {
        Preconditions.checkNotNull(addressUri, "Argument 'addressUri' should not be null");
        if (failedEndpoints != null && failedEndpoints.contains(addressUri)) {
            return Uri.HealthStatus.Unhealthy;
        }
        return addressUri.getEffectiveHealthStatus();
    }
}

