/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ServiceResponseException;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.monitor.query.LogsQueryClientBuilder;
import com.azure.monitor.query.implementation.logs.AzureLogAnalyticsImpl;
import com.azure.monitor.query.implementation.logs.models.BatchQueryRequest;
import com.azure.monitor.query.implementation.logs.models.BatchRequest;
import com.azure.monitor.query.implementation.logs.models.ErrorInfo;
import com.azure.monitor.query.implementation.logs.models.ErrorResponseException;
import com.azure.monitor.query.implementation.logs.models.LogsQueryHelper;
import com.azure.monitor.query.implementation.logs.models.QueryBody;
import com.azure.monitor.query.models.LogsBatchQuery;
import com.azure.monitor.query.models.LogsBatchQueryResultCollection;
import com.azure.monitor.query.models.LogsQueryOptions;
import com.azure.monitor.query.models.LogsQueryResult;
import com.azure.monitor.query.models.LogsQueryResultStatus;
import com.azure.monitor.query.models.QueryTimeInterval;
import java.time.Duration;
import java.util.List;
import reactor.core.publisher.Mono;

@ServiceClient(builder=LogsQueryClientBuilder.class, isAsync=true)
public final class LogsQueryAsyncClient {
    private final AzureLogAnalyticsImpl innerClient;

    LogsQueryAsyncClient(AzureLogAnalyticsImpl innerClient) {
        this.innerClient = innerClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogsQueryResult> queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval) {
        return this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, new LogsQueryOptions()).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<List<T>> queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type) {
        return this.queryWorkspace(workspaceId, query, timeInterval).map(result -> LogsQueryHelper.toObject(result.getTable(), type));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<List<T>> queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options) {
        return this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, options, Context.NONE).map(response -> LogsQueryHelper.toObject(((LogsQueryResult)response.getValue()).getTable(), type));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogsQueryResult>> queryWorkspaceWithResponse(String workspaceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options) {
        return FluxUtil.withContext(context -> this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, options, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<Response<List<T>>> queryWorkspaceWithResponse(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options) {
        return this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, options).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), LogsQueryHelper.toObject(((LogsQueryResult)response.getValue()).getTable(), type)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogsBatchQueryResultCollection> queryBatch(LogsBatchQuery logsBatchQuery) {
        return this.queryBatchWithResponse(logsBatchQuery).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogsBatchQueryResultCollection>> queryBatchWithResponse(LogsBatchQuery logsBatchQuery) {
        return this.queryBatchWithResponse(logsBatchQuery, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogsQueryResult> queryResource(String resourceId, String query, QueryTimeInterval timeInterval) {
        return this.queryResourceWithResponse(resourceId, query, timeInterval, new LogsQueryOptions()).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<List<T>> queryResource(String resourceId, String query, QueryTimeInterval timeInterval, Class<T> type) {
        return this.queryResource(resourceId, query, timeInterval).map(result -> LogsQueryHelper.toObject(result.getTable(), type));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<List<T>> queryResource(String resourceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options) {
        return this.queryResourceWithResponse(resourceId, query, timeInterval, options, Context.NONE).map(response -> LogsQueryHelper.toObject(((LogsQueryResult)response.getValue()).getTable(), type));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogsQueryResult>> queryResourceWithResponse(String resourceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options) {
        return FluxUtil.withContext(context -> this.queryResourceWithResponse(resourceId, query, timeInterval, options, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<Response<List<T>>> queryResourceWithResponse(String resourceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options) {
        return this.queryResourceWithResponse(resourceId, query, timeInterval, options).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), LogsQueryHelper.toObject(((LogsQueryResult)response.getValue()).getTable(), type)));
    }

    Mono<Response<LogsBatchQueryResultCollection>> queryBatchWithResponse(LogsBatchQuery logsBatchQuery, Context context) {
        List<BatchQueryRequest> requests = LogsQueryHelper.getBatchQueries(logsBatchQuery);
        Duration maxServerTimeout = LogsQueryHelper.getMaxServerTimeout(logsBatchQuery);
        if (maxServerTimeout != null) {
            context = context.addData((Object)"azure-response-timeout", (Object)maxServerTimeout.plusSeconds(5L));
        }
        BatchRequest batchRequest = new BatchRequest(requests);
        return this.innerClient.getQueries().batchWithResponseAsync(batchRequest, context).onErrorMap(ex -> {
            if (ex instanceof ErrorResponseException) {
                ErrorResponseException error = (ErrorResponseException)((Object)((Object)ex));
                ErrorInfo errorInfo = error.getValue().getError();
                return new HttpResponseException(error.getMessage(), error.getResponse(), (Object)LogsQueryHelper.mapLogsQueryError(errorInfo));
            }
            return ex;
        }).map(LogsQueryHelper::convertToLogQueryBatchResult);
    }

    private Context updateContext(Duration serverTimeout, Context context) {
        if (serverTimeout != null) {
            return context.addData((Object)"azure-response-timeout", (Object)serverTimeout.plusSeconds(5L));
        }
        return context;
    }

    Mono<Response<LogsQueryResult>> queryWorkspaceWithResponse(String workspaceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options, Context context) {
        String preferHeader = LogsQueryHelper.buildPreferHeaderString(options);
        context = this.updateContext(options.getServerTimeout(), context);
        QueryBody queryBody = new QueryBody(query);
        if (timeInterval != null) {
            queryBody.setTimespan(LogsQueryHelper.toIso8601Format(timeInterval));
        }
        queryBody.setWorkspaces(LogsQueryHelper.getAllWorkspaces(options));
        return this.innerClient.getQueries().executeWithResponseAsync(workspaceId, queryBody, preferHeader, context).onErrorMap(ex -> {
            if (ex instanceof ErrorResponseException) {
                ErrorResponseException error = (ErrorResponseException)((Object)((Object)ex));
                ErrorInfo errorInfo = error.getValue().getError();
                return new HttpResponseException(error.getMessage(), error.getResponse(), (Object)LogsQueryHelper.mapLogsQueryError(errorInfo));
            }
            return ex;
        }).map(LogsQueryHelper::convertToLogQueryResult).handle((response, sink) -> {
            if (((LogsQueryResult)response.getValue()).getQueryResultStatus() == LogsQueryResultStatus.PARTIAL_FAILURE && !options.isAllowPartialErrors()) {
                sink.error((Throwable)new ServiceResponseException("Query execution returned partial errors. To disable exceptions on partial errors, set setAllowPartialErrors in LogsQueryOptions to true."));
            } else {
                sink.next(response);
            }
        });
    }

    Mono<Response<LogsQueryResult>> queryResourceWithResponse(String resourceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options, Context context) {
        if (resourceId != null && resourceId.startsWith("/")) {
            resourceId = resourceId.substring(1);
        }
        String preferHeader = LogsQueryHelper.buildPreferHeaderString(options);
        context = this.updateContext(options.getServerTimeout(), context);
        QueryBody queryBody = new QueryBody(query);
        if (timeInterval != null) {
            queryBody.setTimespan(LogsQueryHelper.toIso8601Format(timeInterval));
        }
        queryBody.setWorkspaces(LogsQueryHelper.getAllWorkspaces(options));
        return this.innerClient.getQueries().resourceExecuteWithResponseAsync(resourceId, queryBody, preferHeader, context).onErrorMap(ex -> {
            if (ex instanceof ErrorResponseException) {
                ErrorResponseException error = (ErrorResponseException)((Object)((Object)ex));
                ErrorInfo errorInfo = error.getValue().getError();
                return new HttpResponseException(error.getMessage(), error.getResponse(), (Object)LogsQueryHelper.mapLogsQueryError(errorInfo));
            }
            return ex;
        }).map(LogsQueryHelper::convertToLogQueryResult).handle((response, sink) -> {
            if (((LogsQueryResult)response.getValue()).getQueryResultStatus() == LogsQueryResultStatus.PARTIAL_FAILURE && !options.isAllowPartialErrors()) {
                sink.error((Throwable)new ServiceResponseException("Query execution returned partial errors. To disable exceptions on partial errors, set setAllowPartialErrors in LogsQueryOptions to true."));
            } else {
                sink.next(response);
            }
        });
    }
}

