/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metricsdefinitions;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.query.implementation.metricsdefinitions.MetricsDefinitionsClientImpl;
import com.azure.monitor.query.implementation.metricsdefinitions.models.ErrorResponseException;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricDefinition;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricDefinitionCollection;
import reactor.core.publisher.Mono;

public final class MetricDefinitionsImpl {
    private final MetricDefinitionsService service;
    private final MetricsDefinitionsClientImpl client;

    MetricDefinitionsImpl(MetricsDefinitionsClientImpl client) {
        this.service = (MetricDefinitionsService)RestProxy.create(MetricDefinitionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricDefinition>> listSinglePageAsync(String resourceUri, String metricnamespace) {
        if (this.client.getHost() == null) {
            throw new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null.");
        }
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getHost(), resourceUri, this.client.getApiVersion(), metricnamespace, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionCollection)res.getValue()).getValue(), null, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricDefinition>> listSinglePageAsync(String resourceUri, String metricnamespace, Context context) {
        if (this.client.getHost() == null) {
            throw new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null.");
        }
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String accept = "application/json";
        return this.service.list(this.client.getHost(), resourceUri, this.client.getApiVersion(), metricnamespace, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionCollection)res.getValue()).getValue(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricDefinition> listAsync(String resourceUri, String metricnamespace) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, metricnamespace));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricDefinition> listAsync(String resourceUri, String metricnamespace, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, metricnamespace, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<MetricDefinition> listSinglePage(String resourceUri, String metricnamespace) {
        if (this.client.getHost() == null) {
            throw new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null.");
        }
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String accept = "application/json";
        Response<MetricDefinitionCollection> res = this.service.listSync(this.client.getHost(), resourceUri, this.client.getApiVersion(), metricnamespace, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionCollection)res.getValue()).getValue(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<MetricDefinition> listSinglePage(String resourceUri, String metricnamespace, Context context) {
        if (this.client.getHost() == null) {
            throw new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null.");
        }
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String accept = "application/json";
        Response<MetricDefinitionCollection> res = this.service.listSync(this.client.getHost(), resourceUri, this.client.getApiVersion(), metricnamespace, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionCollection)res.getValue()).getValue(), null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricDefinition> list(String resourceUri, String metricnamespace) {
        return new PagedIterable(() -> this.listSinglePage(resourceUri, metricnamespace, Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricDefinition> list(String resourceUri, String metricnamespace, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceUri, metricnamespace, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorManagementCli")
    public static interface MetricDefinitionsService {
        @Get(value="/{resourceUri}/providers/Microsoft.Insights/metricDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<MetricDefinitionCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="metricnamespace") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{resourceUri}/providers/Microsoft.Insights/metricDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<MetricDefinitionCollection> listSync(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="metricnamespace") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

