/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.models;

import com.azure.core.models.ResponseError;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.query.models.LogsQueryResultStatus;
import com.azure.monitor.query.models.LogsTable;
import java.util.List;
import java.util.stream.Collectors;

public class LogsQueryResult {
    private final List<LogsTable> logsTables;
    private final BinaryData statistics;
    private final ResponseError error;
    private final BinaryData visualization;
    private final LogsQueryResultStatus queryResultStatus;
    private final ClientLogger logger = new ClientLogger(LogsQueryResult.class);

    public LogsQueryResult(List<LogsTable> logsTables, BinaryData statistics, BinaryData visualization, ResponseError error) {
        this.logsTables = logsTables;
        this.statistics = statistics;
        this.error = error;
        this.visualization = visualization;
        this.queryResultStatus = CoreUtils.isNullOrEmpty(logsTables) && error != null ? LogsQueryResultStatus.FAILURE : (!CoreUtils.isNullOrEmpty(logsTables) && error != null ? LogsQueryResultStatus.PARTIAL_FAILURE : LogsQueryResultStatus.SUCCESS);
    }

    public List<LogsTable> getAllTables() {
        return this.logsTables;
    }

    public LogsTable getTable() {
        if (this.logsTables == null) {
            return null;
        }
        if (this.logsTables.size() > 1) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("The query result contains more than one table. Use getAllTables() method instead."));
        }
        return this.logsTables.get(0);
    }

    <T> List<T> toObject(Class<T> type) {
        if (this.logsTables.size() != 1) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot map result to object if the response contains multiple tables."));
        }
        return this.logsTables.get(0).getRows().stream().map(row -> row.toObject(type)).collect(Collectors.toList());
    }

    public BinaryData getStatistics() {
        return this.statistics;
    }

    public ResponseError getError() {
        return this.error;
    }

    public BinaryData getVisualization() {
        return this.visualization;
    }

    public LogsQueryResultStatus getQueryResultStatus() {
        return this.queryResultStatus;
    }
}

