/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.TypeReference;
import com.azure.monitor.query.models.LogsColumnType;
import com.azure.monitor.query.models.LogsTableCell;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class LogsTableRow {
    private final int rowIndex;
    private final List<LogsTableCell> tableRow;
    private final ClientLogger logger = new ClientLogger(LogsTableRow.class);

    public LogsTableRow(int rowIndex, List<LogsTableCell> tableRow) {
        this.rowIndex = rowIndex;
        this.tableRow = tableRow;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public List<LogsTableCell> getRow() {
        return this.tableRow;
    }

    public Optional<LogsTableCell> getColumnValue(String columnName) {
        return this.tableRow.stream().filter(cell -> cell.getColumnName().equals(columnName)).findFirst();
    }

    <T> T toObject(Class<T> type) {
        try {
            Object t = type.newInstance();
            Map<String, Field> declaredFieldMapping = Arrays.stream(type.getDeclaredFields()).collect(Collectors.toMap(field -> field.getName().toLowerCase(Locale.ROOT), field -> field));
            this.tableRow.stream().forEach(tableCell -> {
                String columnName = tableCell.getColumnName();
                try {
                    Field field = (Field)declaredFieldMapping.get(columnName.toLowerCase(Locale.ROOT));
                    if (field == null) {
                        return;
                    }
                    field.setAccessible(true);
                    if (tableCell.getColumnType() == LogsColumnType.BOOL) {
                        field.set(t, tableCell.getValueAsBoolean());
                    } else if (tableCell.getColumnType() == LogsColumnType.DATETIME) {
                        field.set(t, tableCell.getValueAsDateTime());
                    } else if (tableCell.getColumnType() == LogsColumnType.DYNAMIC) {
                        if (tableCell.getValueAsDynamic() != null) {
                            field.set(t, tableCell.getValueAsDynamic().toObject(TypeReference.createInstance(field.getType())));
                        }
                    } else if (tableCell.getColumnType() == LogsColumnType.INT) {
                        field.set(t, tableCell.getValueAsInteger());
                    } else if (tableCell.getColumnType() == LogsColumnType.LONG) {
                        field.set(t, tableCell.getValueAsLong());
                    } else if (tableCell.getColumnType() == LogsColumnType.REAL || tableCell.getColumnType() == LogsColumnType.DECIMAL) {
                        field.set(t, tableCell.getValueAsDouble());
                    } else if (tableCell.getColumnType() == LogsColumnType.STRING || tableCell.getColumnType() == LogsColumnType.GUID || tableCell.getColumnType() == LogsColumnType.TIMESPAN) {
                        field.set(t, tableCell.getValueAsString());
                    }
                    field.setAccessible(false);
                }
                catch (IllegalAccessException ex) {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Failed to set column value for " + columnName, ex));
                }
            });
            return t;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot create an instance of class " + type.getName(), ex));
        }
    }
}

