/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.models;

import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class QueryTimeInterval {
    public static final QueryTimeInterval ALL = new QueryTimeInterval(OffsetDateTime.MIN, OffsetDateTime.MAX);
    public static final QueryTimeInterval LAST_5_MINUTES = new QueryTimeInterval(Duration.ofMinutes(5L));
    public static final QueryTimeInterval LAST_30_MINUTES = new QueryTimeInterval(Duration.ofMinutes(30L));
    public static final QueryTimeInterval LAST_1_HOUR = new QueryTimeInterval(Duration.ofHours(1L));
    public static final QueryTimeInterval LAST_4_HOURS = new QueryTimeInterval(Duration.ofHours(4L));
    public static final QueryTimeInterval LAST_12_HOURS = new QueryTimeInterval(Duration.ofHours(12L));
    public static final QueryTimeInterval LAST_DAY = new QueryTimeInterval(Duration.ofDays(1L));
    public static final QueryTimeInterval LAST_2_DAYS = new QueryTimeInterval(Duration.ofDays(2L));
    public static final QueryTimeInterval LAST_3_DAYS = new QueryTimeInterval(Duration.ofDays(3L));
    public static final QueryTimeInterval LAST_7_DAYS = new QueryTimeInterval(Duration.ofDays(7L));
    private static final ClientLogger LOGGER = new ClientLogger(QueryTimeInterval.class);
    private static final String ERROR_MESSAGE = "%s is an invalid time interval. It must be in one of the following ISO 8601 time interval formats: duration, startDuration/endTime, startTime/endTime, startTime/endDuration";
    private final Duration duration;
    private final OffsetDateTime startTime;
    private final OffsetDateTime endTime;

    public QueryTimeInterval(Duration duration) {
        this.duration = Objects.requireNonNull(duration, "'duration' cannot be null");
        this.startTime = null;
        this.endTime = null;
    }

    public QueryTimeInterval(OffsetDateTime startTime, OffsetDateTime endTime) {
        this.startTime = Objects.requireNonNull(startTime, "'startTime' cannot be null");
        this.endTime = Objects.requireNonNull(endTime, "'endTime' cannot be null");
        this.duration = null;
    }

    public QueryTimeInterval(OffsetDateTime startTime, Duration duration) {
        this.startTime = Objects.requireNonNull(startTime, "'startTime' cannot be null");
        this.duration = Objects.requireNonNull(duration, "'duration' cannot be null");
        this.endTime = null;
    }

    QueryTimeInterval(Duration duration, OffsetDateTime endTime) {
        this.endTime = Objects.requireNonNull(endTime, "'endTime' cannot be null");
        this.duration = Objects.requireNonNull(duration, "'duration' cannot be null");
        this.startTime = null;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public OffsetDateTime getStartTime() {
        if (this.startTime != null) {
            return this.startTime;
        }
        if (this.duration != null && this.endTime != null) {
            return this.endTime.minusNanos(this.duration.toNanos());
        }
        return null;
    }

    public OffsetDateTime getEndTime() {
        if (this.endTime != null) {
            return this.endTime;
        }
        if (this.startTime != null && this.duration != null) {
            return this.startTime.plusNanos(this.duration.toNanos());
        }
        return null;
    }

    public static QueryTimeInterval parse(String value) {
        Objects.requireNonNull(value);
        String[] parts = value.split("/");
        if (parts.length == 1) {
            Duration duration = QueryTimeInterval.parseDuration(parts[0]);
            if (duration == null || parts[0].length() + 1 == value.length()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(ERROR_MESSAGE, value)));
            }
            return new QueryTimeInterval(duration);
        }
        if (parts.length == 2) {
            Duration startDuration = QueryTimeInterval.parseDuration(parts[0]);
            OffsetDateTime startTime = QueryTimeInterval.parseTime(parts[0]);
            Duration endDuration = QueryTimeInterval.parseDuration(parts[1]);
            OffsetDateTime endTime = QueryTimeInterval.parseTime(parts[1]);
            if (startDuration != null && endTime != null) {
                return new QueryTimeInterval(startDuration, endTime);
            }
            if (startTime != null && endTime != null) {
                return new QueryTimeInterval(startTime, endTime);
            }
            if (startTime != null && endDuration != null) {
                return new QueryTimeInterval(startTime, endDuration);
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(ERROR_MESSAGE, value)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.duration != null && this.endTime != null) {
            sb.append("duration: ").append(this.duration).append(", ").append("end time: ").append(this.endTime);
        } else if (this.startTime != null && this.endTime != null) {
            sb.append("start time: ").append(this.startTime).append(", ").append("end time: ").append(this.endTime);
        } else if (this.startTime != null && this.duration != null) {
            sb.append("start time: ").append(this.startTime).append(", ").append("duration: ").append(this.duration);
        } else {
            sb.append("duration: ").append(this.duration);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryTimeInterval that = (QueryTimeInterval)o;
        return Objects.equals(this.duration, that.duration) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.startTime, this.endTime);
    }

    private static OffsetDateTime parseTime(String value) {
        try {
            return OffsetDateTime.parse(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Duration parseDuration(String value) {
        try {
            return Duration.parse(value);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

