/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.util;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.util.CoreUtils;
import com.azure.search.documents.indexes.implementation.models.AnalyzeResult;
import com.azure.search.documents.indexes.implementation.models.ListDataSourcesResult;
import com.azure.search.documents.indexes.implementation.models.ListIndexersResult;
import com.azure.search.documents.indexes.implementation.models.ListSkillsetsResult;
import com.azure.search.documents.indexes.implementation.models.ListSynonymMapsResult;
import com.azure.search.documents.indexes.implementation.models.SearchErrorException;
import com.azure.search.documents.indexes.models.AnalyzedTokenInfo;
import com.azure.search.documents.indexes.models.BlobIndexerDataToExtract;
import com.azure.search.documents.indexes.models.BlobIndexerImageAction;
import com.azure.search.documents.indexes.models.BlobIndexerParsingMode;
import com.azure.search.documents.indexes.models.BlobIndexerPdfTextRotationAlgorithm;
import com.azure.search.documents.indexes.models.IndexerExecutionEnvironment;
import com.azure.search.documents.indexes.models.IndexingParametersConfiguration;
import com.azure.search.documents.indexes.models.SearchIndex;
import com.azure.search.documents.indexes.models.SearchIndexer;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import com.azure.search.documents.indexes.models.SearchIndexerSkillset;
import com.azure.search.documents.indexes.models.SynonymMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MappingUtils {
    public static PagedResponse<SearchIndexerDataSourceConnection> mappingPagingDataSource(Response<ListDataSourcesResult> dataSourceResponse) {
        List<SearchIndexerDataSourceConnection> dataSourceMaps = ((ListDataSourcesResult)dataSourceResponse.getValue()).getDataSources();
        return new PagedResponseBase(dataSourceResponse.getRequest(), dataSourceResponse.getStatusCode(), dataSourceResponse.getHeaders(), dataSourceMaps, null, null);
    }

    public static PagedResponse<String> mappingPagingDataSourceNames(Response<ListDataSourcesResult> dataSourceResponse) {
        List dataSourceNames = ((ListDataSourcesResult)dataSourceResponse.getValue()).getDataSources().stream().map(SearchIndexerDataSourceConnection::getName).collect(Collectors.toList());
        return new PagedResponseBase(dataSourceResponse.getRequest(), dataSourceResponse.getStatusCode(), dataSourceResponse.getHeaders(), dataSourceNames, null, null);
    }

    public static PagedResponse<String> mappingPagingSearchIndexNames(PagedResponse<SearchIndex> searchIndexResponse) {
        ArrayList pageItems = new ArrayList();
        searchIndexResponse.getValue().forEach(item -> pageItems.add(item.getName()));
        return new PagedResponseBase(searchIndexResponse.getRequest(), searchIndexResponse.getStatusCode(), searchIndexResponse.getHeaders(), pageItems, (String)searchIndexResponse.getContinuationToken(), null);
    }

    public static PagedResponse<SearchIndexer> mappingPagingSearchIndexer(Response<ListIndexersResult> searchIndexerResponse) {
        List<SearchIndexer> searchIndexers = ((ListIndexersResult)searchIndexerResponse.getValue()).getIndexers();
        return new PagedResponseBase(searchIndexerResponse.getRequest(), searchIndexerResponse.getStatusCode(), searchIndexerResponse.getHeaders(), searchIndexers, null, null);
    }

    public static PagedResponse<String> mappingPagingSearchIndexerNames(Response<ListIndexersResult> searchIndexerResponse) {
        List searchIndexerNames = ((ListIndexersResult)searchIndexerResponse.getValue()).getIndexers().stream().map(SearchIndexer::getName).collect(Collectors.toList());
        return new PagedResponseBase(searchIndexerResponse.getRequest(), searchIndexerResponse.getStatusCode(), searchIndexerResponse.getHeaders(), searchIndexerNames, null, null);
    }

    public static PagedResponse<SearchIndexerSkillset> mappingPagingSkillset(Response<ListSkillsetsResult> skillsetResponse) {
        return new PagedResponseBase(skillsetResponse.getRequest(), skillsetResponse.getStatusCode(), skillsetResponse.getHeaders(), ((ListSkillsetsResult)skillsetResponse.getValue()).getSkillsets(), null, null);
    }

    public static PagedResponse<String> mappingPagingSkillsetNames(Response<ListSkillsetsResult> skillsetResponse) {
        List skillsetNames = ((ListSkillsetsResult)skillsetResponse.getValue()).getSkillsets().stream().map(SearchIndexerSkillset::getName).collect(Collectors.toList());
        return new PagedResponseBase(skillsetResponse.getRequest(), skillsetResponse.getStatusCode(), skillsetResponse.getHeaders(), skillsetNames, null, null);
    }

    public static PagedResponse<SynonymMap> mappingPagingSynonymMap(Response<ListSynonymMapsResult> synonymMapResponse) {
        return new PagedResponseBase(synonymMapResponse.getRequest(), synonymMapResponse.getStatusCode(), synonymMapResponse.getHeaders(), ((ListSynonymMapsResult)synonymMapResponse.getValue()).getSynonymMaps(), null, null);
    }

    public static PagedResponse<String> mappingPagingSynonymMapNames(Response<ListSynonymMapsResult> synonymMapsResponse) {
        List synonymMapNames = ((ListSynonymMapsResult)synonymMapsResponse.getValue()).getSynonymMaps().stream().map(SynonymMap::getName).collect(Collectors.toList());
        return new PagedResponseBase(synonymMapsResponse.getRequest(), synonymMapsResponse.getStatusCode(), synonymMapsResponse.getHeaders(), synonymMapNames, null, null);
    }

    public static PagedResponse<AnalyzedTokenInfo> mappingTokenInfo(Response<AnalyzeResult> resultResponse) {
        List<AnalyzedTokenInfo> tokenInfos = ((AnalyzeResult)resultResponse.getValue()).getTokens();
        return new PagedResponseBase(resultResponse.getRequest(), resultResponse.getStatusCode(), resultResponse.getHeaders(), tokenInfos, null, null);
    }

    public static Throwable exceptionMapper(Throwable throwable) {
        if (throwable instanceof SearchErrorException) {
            SearchErrorException exception = (SearchErrorException)((Object)throwable);
            return new HttpResponseException(exception.getMessage(), exception.getResponse());
        }
        if (throwable instanceof com.azure.search.documents.implementation.models.SearchErrorException) {
            com.azure.search.documents.implementation.models.SearchErrorException exception = (com.azure.search.documents.implementation.models.SearchErrorException)((Object)throwable);
            return new HttpResponseException(exception.getMessage(), exception.getResponse());
        }
        return throwable;
    }

    public static IndexingParametersConfiguration mapToIndexingParametersConfiguration(Map<String, Object> configuration) {
        if (CoreUtils.isNullOrEmpty(configuration)) {
            return null;
        }
        IndexingParametersConfiguration config = new IndexingParametersConfiguration();
        LinkedHashMap<String, Object> additionalProperties = null;
        block36: for (Map.Entry<String, Object> kvp : configuration.entrySet()) {
            String key = kvp.getKey();
            if (key == null) continue;
            Object value = kvp.getValue();
            switch (key) {
                case "parsingMode": {
                    config.setParsingMode(MappingUtils.converter(value, BlobIndexerParsingMode::fromString));
                    continue block36;
                }
                case "excludedFileNameExtensions": {
                    config.setExcludedFileNameExtensions((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
                case "indexedFileNameExtensions": {
                    config.setIndexedFileNameExtensions((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
                case "failOnUnsupportedContentType": {
                    config.setFailOnUnsupportedContentType(MappingUtils.converter(value, Boolean::parseBoolean));
                    continue block36;
                }
                case "failOnUnprocessableDocument": {
                    config.setFailOnUnprocessableDocument(MappingUtils.converter(value, Boolean::parseBoolean));
                    continue block36;
                }
                case "indexStorageMetadataOnlyForOversizedDocuments": {
                    config.setIndexStorageMetadataOnlyForOversizedDocuments(MappingUtils.converter(value, Boolean::parseBoolean));
                    continue block36;
                }
                case "delimitedTextHeaders": {
                    config.setDelimitedTextHeaders((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
                case "delimitedTextDelimiter": {
                    config.setDelimitedTextDelimiter((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
                case "firstLineContainsHeaders": {
                    config.setFirstLineContainsHeaders(MappingUtils.converter(value, Boolean::parseBoolean));
                    continue block36;
                }
                case "documentRoot": {
                    config.setDocumentRoot((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
                case "dataToExtract": {
                    config.setDataToExtract(MappingUtils.converter(value, BlobIndexerDataToExtract::fromString));
                    continue block36;
                }
                case "imageAction": {
                    config.setImageAction(MappingUtils.converter(value, BlobIndexerImageAction::fromString));
                    continue block36;
                }
                case "allowSkillsetToReadFileData": {
                    config.setAllowSkillsetToReadFileData(MappingUtils.converter(value, Boolean::parseBoolean));
                    continue block36;
                }
                case "pdfTextRotationAlgorithm": {
                    config.setPdfTextRotationAlgorithm(MappingUtils.converter(value, BlobIndexerPdfTextRotationAlgorithm::fromString));
                    continue block36;
                }
                case "executionEnvironment": {
                    config.setExecutionEnvironment(MappingUtils.converter(value, IndexerExecutionEnvironment::fromString));
                    continue block36;
                }
                case "queryTimeout": {
                    config.setQueryTimeout((String)MappingUtils.converter(value, Function.identity()));
                    continue block36;
                }
            }
            if (additionalProperties == null) {
                additionalProperties = new LinkedHashMap<String, Object>();
            }
            additionalProperties.put(key, value);
        }
        return config.setAdditionalProperties(additionalProperties);
    }

    private static <T> T converter(Object value, Function<String, T> conv) {
        return value == null ? null : (T)conv.apply(String.valueOf(value));
    }

    public static Map<String, Object> indexingParametersConfigurationToMap(IndexingParametersConfiguration params) {
        if (params == null) {
            return null;
        }
        LinkedHashMap<String, Object> configuration = new LinkedHashMap<String, Object>();
        MappingUtils.setConfigurationValue((Object)params.getParsingMode(), "parsingMode", configuration);
        MappingUtils.setConfigurationValue(params.getExcludedFileNameExtensions(), "excludedFileNameExtensions", configuration);
        MappingUtils.setConfigurationValue(params.getIndexedFileNameExtensions(), "indexedFileNameExtensions", configuration);
        MappingUtils.setConfigurationValue(params.isFailOnUnsupportedContentType(), "failOnUnsupportedContentType", configuration);
        MappingUtils.setConfigurationValue(params.isFailOnUnprocessableDocument(), "failOnUnprocessableDocument", configuration);
        MappingUtils.setConfigurationValue(params.isIndexStorageMetadataOnlyForOversizedDocuments(), "indexStorageMetadataOnlyForOversizedDocuments", configuration);
        MappingUtils.setConfigurationValue(params.getDelimitedTextHeaders(), "delimitedTextHeaders", configuration);
        MappingUtils.setConfigurationValue(params.getDelimitedTextDelimiter(), "delimitedTextDelimiter", configuration);
        MappingUtils.setConfigurationValue(params.isFirstLineContainsHeaders(), "firstLineContainsHeaders", configuration);
        MappingUtils.setConfigurationValue(params.getDocumentRoot(), "documentRoot", configuration);
        MappingUtils.setConfigurationValue((Object)params.getDataToExtract(), "dataToExtract", configuration);
        MappingUtils.setConfigurationValue((Object)params.getImageAction(), "imageAction", configuration);
        MappingUtils.setConfigurationValue(params.isAllowSkillsetToReadFileData(), "allowSkillsetToReadFileData", configuration);
        MappingUtils.setConfigurationValue((Object)params.getPdfTextRotationAlgorithm(), "pdfTextRotationAlgorithm", configuration);
        MappingUtils.setConfigurationValue((Object)params.getExecutionEnvironment(), "executionEnvironment", configuration);
        MappingUtils.setConfigurationValue(params.getQueryTimeout(), "queryTimeout", configuration);
        Map<String, Object> additionalProperties = params.getAdditionalProperties();
        if (!CoreUtils.isNullOrEmpty(additionalProperties)) {
            configuration.putAll(additionalProperties);
        }
        return configuration;
    }

    private static void setConfigurationValue(Object value, String key, Map<String, Object> configuration) {
        if (value == null) {
            return;
        }
        configuration.put(key, String.valueOf(value));
    }
}

