/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ListDataSourcesResult
implements JsonSerializable<ListDataSourcesResult> {
    private final List<SearchIndexerDataSourceConnection> dataSources;

    public ListDataSourcesResult(List<SearchIndexerDataSourceConnection> dataSources) {
        this.dataSources = dataSources;
    }

    public List<SearchIndexerDataSourceConnection> getDataSources() {
        return this.dataSources;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ListDataSourcesResult fromJson(JsonReader jsonReader) throws IOException {
        return (ListDataSourcesResult)jsonReader.readObject(reader -> {
            boolean dataSourcesFound = false;
            List dataSources = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    dataSources = reader.readArray(reader1 -> SearchIndexerDataSourceConnection.fromJson(reader1));
                    dataSourcesFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (dataSourcesFound) {
                ListDataSourcesResult deserializedListDataSourcesResult = new ListDataSourcesResult(dataSources);
                return deserializedListDataSourcesResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!dataSourcesFound) {
                missingProperties.add("value");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

