/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.FreshnessScoringParameters;
import com.azure.search.documents.indexes.models.ScoringFunction;
import com.azure.search.documents.indexes.models.ScoringFunctionInterpolation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class FreshnessScoringFunction
extends ScoringFunction {
    private final FreshnessScoringParameters parameters;

    public FreshnessScoringFunction(String fieldName, double boost, FreshnessScoringParameters parameters) {
        super(fieldName, boost);
        this.parameters = parameters;
    }

    public FreshnessScoringParameters getParameters() {
        return this.parameters;
    }

    @Override
    public FreshnessScoringFunction setInterpolation(ScoringFunctionInterpolation interpolation) {
        super.setInterpolation(interpolation);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", "freshness");
        jsonWriter.writeStringField("fieldName", this.getFieldName());
        jsonWriter.writeDoubleField("boost", this.getBoost());
        jsonWriter.writeStringField("interpolation", Objects.toString((Object)this.getInterpolation(), null));
        jsonWriter.writeJsonField("freshness", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static FreshnessScoringFunction fromJson(JsonReader jsonReader) throws IOException {
        return (FreshnessScoringFunction)jsonReader.readObject(reader -> {
            boolean fieldNameFound = false;
            String fieldName = null;
            boolean boostFound = false;
            double boost = 0.0;
            ScoringFunctionInterpolation interpolation = null;
            boolean parametersFound = false;
            FreshnessScoringParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(jsonFieldName)) {
                    String type = reader.getString();
                    if ("freshness".equals(type)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'freshness'. The found 'type' was '" + type + "'.");
                }
                if ("fieldName".equals(jsonFieldName)) {
                    fieldName = reader.getString();
                    fieldNameFound = true;
                    continue;
                }
                if ("boost".equals(jsonFieldName)) {
                    boost = reader.getDouble();
                    boostFound = true;
                    continue;
                }
                if ("interpolation".equals(jsonFieldName)) {
                    interpolation = ScoringFunctionInterpolation.fromString(reader.getString());
                    continue;
                }
                if ("freshness".equals(jsonFieldName)) {
                    parameters = FreshnessScoringParameters.fromJson(reader);
                    parametersFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (fieldNameFound && boostFound && parametersFound) {
                FreshnessScoringFunction deserializedFreshnessScoringFunction = new FreshnessScoringFunction(fieldName, boost, parameters);
                deserializedFreshnessScoringFunction.setInterpolation(interpolation);
                return deserializedFreshnessScoringFunction;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!fieldNameFound) {
                missingProperties.add("fieldName");
            }
            if (!boostFound) {
                missingProperties.add("boost");
            }
            if (!parametersFound) {
                missingProperties.add("freshness");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

