/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class InputFieldMappingEntry
implements JsonSerializable<InputFieldMappingEntry> {
    private final String name;
    private String source;
    private String sourceContext;
    private List<InputFieldMappingEntry> inputs;

    public InputFieldMappingEntry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public InputFieldMappingEntry setSource(String source) {
        this.source = source;
        return this;
    }

    public String getSourceContext() {
        return this.sourceContext;
    }

    public InputFieldMappingEntry setSourceContext(String sourceContext) {
        this.sourceContext = sourceContext;
        return this;
    }

    public List<InputFieldMappingEntry> getInputs() {
        return this.inputs;
    }

    public InputFieldMappingEntry setInputs(List<InputFieldMappingEntry> inputs) {
        this.inputs = inputs;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("sourceContext", this.sourceContext);
        jsonWriter.writeArrayField("inputs", this.inputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static InputFieldMappingEntry fromJson(JsonReader jsonReader) throws IOException {
        return (InputFieldMappingEntry)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String source = null;
            String sourceContext = null;
            List inputs = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("source".equals(fieldName)) {
                    source = reader.getString();
                    continue;
                }
                if ("sourceContext".equals(fieldName)) {
                    sourceContext = reader.getString();
                    continue;
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                InputFieldMappingEntry deserializedInputFieldMappingEntry = new InputFieldMappingEntry(name);
                deserializedInputFieldMappingEntry.source = source;
                deserializedInputFieldMappingEntry.sourceContext = sourceContext;
                deserializedInputFieldMappingEntry.inputs = inputs;
                return deserializedInputFieldMappingEntry;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public InputFieldMappingEntry setInputs(InputFieldMappingEntry ... inputs) {
        this.inputs = inputs == null ? null : Arrays.asList(inputs);
        return this;
    }
}

