/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class LanguageDetectionSkill
extends SearchIndexerSkill {
    private String defaultCountryHint;
    private String modelVersion;

    public LanguageDetectionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public String getDefaultCountryHint() {
        return this.defaultCountryHint;
    }

    public LanguageDetectionSkill setDefaultCountryHint(String defaultCountryHint) {
        this.defaultCountryHint = defaultCountryHint;
        return this;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public LanguageDetectionSkill setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    @Override
    public LanguageDetectionSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public LanguageDetectionSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public LanguageDetectionSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Skills.Text.LanguageDetectionSkill");
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("defaultCountryHint", this.defaultCountryHint);
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        return jsonWriter.writeEndObject();
    }

    public static LanguageDetectionSkill fromJson(JsonReader jsonReader) throws IOException {
        return (LanguageDetectionSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String defaultCountryHint = null;
            String modelVersion = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Skills.Text.LanguageDetectionSkill".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.LanguageDetectionSkill'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("defaultCountryHint".equals(fieldName)) {
                    defaultCountryHint = reader.getString();
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    modelVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                LanguageDetectionSkill deserializedLanguageDetectionSkill = new LanguageDetectionSkill(inputs, outputs);
                deserializedLanguageDetectionSkill.setName(name);
                deserializedLanguageDetectionSkill.setDescription(description);
                deserializedLanguageDetectionSkill.setContext(context);
                deserializedLanguageDetectionSkill.defaultCountryHint = defaultCountryHint;
                deserializedLanguageDetectionSkill.modelVersion = modelVersion;
                return deserializedLanguageDetectionSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

