/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;

public final class PatternReplaceTokenFilter
extends TokenFilter {
    private final String pattern;
    private final String replacement;

    public PatternReplaceTokenFilter(String name, String pattern, String replacement) {
        super(name);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.PatternReplaceTokenFilter");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("pattern", this.pattern);
        jsonWriter.writeStringField("replacement", this.replacement);
        return jsonWriter.writeEndObject();
    }

    public static PatternReplaceTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (PatternReplaceTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean patternFound = false;
            String pattern = null;
            boolean replacementFound = false;
            String replacement = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.PatternReplaceTokenFilter".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.PatternReplaceTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("pattern".equals(fieldName)) {
                    pattern = reader.getString();
                    patternFound = true;
                    continue;
                }
                if ("replacement".equals(fieldName)) {
                    replacement = reader.getString();
                    replacementFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && patternFound && replacementFound) {
                PatternReplaceTokenFilter deserializedPatternReplaceTokenFilter = new PatternReplaceTokenFilter(name, pattern, replacement);
                return deserializedPatternReplaceTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!patternFound) {
                missingProperties.add("pattern");
            }
            if (!replacementFound) {
                missingProperties.add("replacement");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

