/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.ExhaustiveKnnAlgorithmConfiguration;
import com.azure.search.documents.indexes.models.HnswAlgorithmConfiguration;
import java.io.IOException;

public class VectorSearchAlgorithmConfiguration
implements JsonSerializable<VectorSearchAlgorithmConfiguration> {
    private final String name;

    public VectorSearchAlgorithmConfiguration(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static VectorSearchAlgorithmConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VectorSearchAlgorithmConfiguration)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            JsonReader readerToUse = reader.bufferObject();
            readerToUse.nextToken();
            while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = readerToUse.getFieldName();
                readerToUse.nextToken();
                if ("kind".equals(fieldName)) {
                    discriminatorValue = readerToUse.getString();
                    break;
                }
                readerToUse.skipChildren();
            }
            if (discriminatorValue != null) {
                readerToUse = readerToUse.reset();
            }
            if ("hnsw".equals(discriminatorValue)) {
                return HnswAlgorithmConfiguration.fromJson(readerToUse);
            }
            if ("exhaustiveKnn".equals(discriminatorValue)) {
                return ExhaustiveKnnAlgorithmConfiguration.fromJson(readerToUse);
            }
            throw new IllegalStateException("Discriminator field 'kind' didn't match one of the expected values 'hnsw', or 'exhaustiveKnn'. It was: '" + discriminatorValue + "'.");
        });
    }
}

