/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.core.exception.AzureException;
import com.azure.search.documents.SearchDocument;
import com.azure.search.documents.models.IndexAction;
import com.azure.search.documents.models.IndexBatchBase;
import com.azure.search.documents.models.IndexDocumentsResult;
import com.azure.search.documents.models.IndexingResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class IndexBatchException
extends AzureException {
    private static final long serialVersionUID = -3478124828996650248L;
    private static final String MESSAGE_FORMAT = "%s of %s indexing actions in the batch failed. The remaining actions succeeded and modified the index. Check indexingResults for the status of each index action.";
    private final ArrayList<IndexingResult> results;

    public IndexBatchException(IndexDocumentsResult result) {
        super(IndexBatchException.createMessage(result));
        this.results = new ArrayList<IndexingResult>(result.getResults());
    }

    public IndexBatchBase<SearchDocument> findFailedActionsToRetry(IndexBatchBase<SearchDocument> originalBatch, String keyFieldName) {
        return this.findFailedActionsToRetry(originalBatch, (T searchDocument) -> searchDocument.get(keyFieldName).toString());
    }

    public <T> IndexBatchBase<T> findFailedActionsToRetry(IndexBatchBase<T> originBatch, Function<T, String> keySelector) {
        List<IndexAction<T>> failedActions = this.doFindFailedActionsToRetry(originBatch, keySelector);
        return new IndexBatchBase<T>(failedActions);
    }

    public List<IndexingResult> getIndexingResults() {
        return this.results;
    }

    private static String createMessage(IndexDocumentsResult result) {
        long failedResultCount = result.getResults().stream().filter(r -> !r.isSucceeded()).count();
        return String.format(MESSAGE_FORMAT, failedResultCount, result.getResults().size());
    }

    private <T> List<IndexAction<T>> doFindFailedActionsToRetry(IndexBatchBase<T> originBatch, Function<T, String> keySelector) {
        Set uniqueRetriableKeys = this.getIndexingResults().stream().filter(result -> IndexBatchException.isRetriableStatusCode(result.getStatusCode())).map(IndexingResult::getKey).collect(Collectors.toSet());
        return originBatch.getActions().stream().filter(action -> this.isActionIncluded((IndexAction)action, uniqueRetriableKeys, keySelector)).collect(Collectors.toList());
    }

    private <T> boolean isActionIncluded(IndexAction<T> action, Set<String> uniqueRetriableKeys, Function<T, String> keySelector) {
        if (action.getDocument() != null) {
            return uniqueRetriableKeys.contains(keySelector.apply(action.getDocument()));
        }
        return false;
    }

    private static boolean isRetriableStatusCode(int statusCode) {
        return statusCode == 409 || statusCode == 422 || statusCode == 503;
    }
}

