/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.util;

import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.search.documents.implementation.util.SearchPagedResponseAccessHelper;
import com.azure.search.documents.models.FacetResult;
import com.azure.search.documents.models.QueryAnswerResult;
import com.azure.search.documents.models.SearchResult;
import com.azure.search.documents.models.SemanticErrorReason;
import com.azure.search.documents.models.SemanticSearchResultsType;
import java.util.List;
import java.util.Map;

public final class SearchPagedResponse
extends PagedResponseBase<Void, SearchResult> {
    private final List<SearchResult> value;
    private final Long count;
    private final Double coverage;
    private final Map<String, List<FacetResult>> facets;
    private final List<QueryAnswerResult> queryAnswers;
    private final SemanticErrorReason semanticErrorReason;
    private final SemanticSearchResultsType semanticSearchResultsType;

    public SearchPagedResponse(Response<List<SearchResult>> response, String continuationToken, Map<String, List<FacetResult>> facets, Long count, Double coverage) {
        this(response, continuationToken, facets, count, coverage, null, null, null);
    }

    public SearchPagedResponse(Response<List<SearchResult>> response, String continuationToken, Map<String, List<FacetResult>> facets, Long count, Double coverage, List<QueryAnswerResult> queryAnswers, SemanticErrorReason semanticErrorReason, SemanticSearchResultsType semanticSearchResultsType) {
        super(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), continuationToken, null);
        this.value = (List)response.getValue();
        this.facets = facets;
        this.count = count;
        this.coverage = coverage;
        this.queryAnswers = queryAnswers;
        this.semanticErrorReason = semanticErrorReason;
        this.semanticSearchResultsType = semanticSearchResultsType;
    }

    Double getCoverage() {
        return this.coverage;
    }

    Map<String, List<FacetResult>> getFacets() {
        return this.facets;
    }

    Long getCount() {
        return this.count;
    }

    List<QueryAnswerResult> getQueryAnswers() {
        return this.queryAnswers;
    }

    SemanticErrorReason getSemanticErrorReason() {
        return this.semanticErrorReason;
    }

    SemanticSearchResultsType getSemanticSearchResultsType() {
        return this.semanticSearchResultsType;
    }

    public List<SearchResult> getValue() {
        return this.value;
    }

    static {
        SearchPagedResponseAccessHelper.setAccessor(new SearchPagedResponseAccessHelper.SearchPagedResponseAccessor(){

            @Override
            public Double getCoverage(SearchPagedResponse response) {
                return response.getCoverage();
            }

            @Override
            public Map<String, List<FacetResult>> getFacets(SearchPagedResponse response) {
                return response.getFacets();
            }

            @Override
            public Long getCount(SearchPagedResponse response) {
                return response.getCount();
            }

            @Override
            public List<QueryAnswerResult> getQueryAnswers(SearchPagedResponse response) {
                return response.getQueryAnswers();
            }

            @Override
            public SemanticErrorReason getSemanticErrorReason(SearchPagedResponse response) {
                return response.getSemanticErrorReason();
            }

            @Override
            public SemanticSearchResultsType getSemanticSearchResultsType(SearchPagedResponse response) {
                return response.getSemanticSearchResultsType();
            }
        });
    }
}

