/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.ServicesFilterBlobsResponse;
import com.azure.storage.blob.implementation.models.ServicesGetAccountInfoResponse;
import com.azure.storage.blob.implementation.models.ServicesGetPropertiesResponse;
import com.azure.storage.blob.implementation.models.ServicesGetStatisticsResponse;
import com.azure.storage.blob.implementation.models.ServicesGetUserDelegationKeyResponse;
import com.azure.storage.blob.implementation.models.ServicesListBlobContainersSegmentResponse;
import com.azure.storage.blob.implementation.models.ServicesSetPropertiesResponse;
import com.azure.storage.blob.implementation.models.ServicesSubmitBatchResponse;
import com.azure.storage.blob.models.BlobServiceProperties;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.KeyInfo;
import com.azure.storage.blob.models.ListBlobContainersIncludeType;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private ServicesService service;
    private AzureBlobStorageImpl client;

    public ServicesImpl(AzureBlobStorageImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<ServicesSetPropertiesResponse> setPropertiesWithRestResponseAsync(BlobServiceProperties blobServiceProperties, Context context) {
        Integer timeout = null;
        String requestId = null;
        String restype = "service";
        String comp = "properties";
        return this.service.setProperties(this.client.getUrl(), blobServiceProperties, timeout, this.client.getVersion(), requestId, "service", "properties", context);
    }

    public Mono<ServicesSetPropertiesResponse> setPropertiesWithRestResponseAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        return this.service.setProperties(this.client.getUrl(), blobServiceProperties, timeout, this.client.getVersion(), requestId, "service", "properties", context);
    }

    public Mono<ServicesGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String requestId = null;
        String restype = "service";
        String comp = "properties";
        return this.service.getProperties(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "service", "properties", context);
    }

    public Mono<ServicesGetPropertiesResponse> getPropertiesWithRestResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        return this.service.getProperties(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "service", "properties", context);
    }

    public Mono<ServicesGetStatisticsResponse> getStatisticsWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String requestId = null;
        String restype = "service";
        String comp = "stats";
        return this.service.getStatistics(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "service", "stats", context);
    }

    public Mono<ServicesGetStatisticsResponse> getStatisticsWithRestResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        return this.service.getStatistics(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "service", "stats", context);
    }

    public Mono<ServicesListBlobContainersSegmentResponse> listBlobContainersSegmentWithRestResponseAsync(Context context) {
        String prefix = null;
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String requestId = null;
        String comp = "list";
        String listBlobContainersIncludeTypeConverted = null;
        return this.service.listBlobContainersSegment(this.client.getUrl(), prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "list", context);
    }

    public Mono<ServicesListBlobContainersSegmentResponse> listBlobContainersSegmentWithRestResponseAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String listBlobContainersIncludeTypeConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(listBlobContainersIncludeType, CollectionFormat.CSV);
        return this.service.listBlobContainersSegment(this.client.getUrl(), prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "list", context);
    }

    public Mono<ServicesGetUserDelegationKeyResponse> getUserDelegationKeyWithRestResponseAsync(KeyInfo keyInfo, Context context) {
        Integer timeout = null;
        String requestId = null;
        String restype = "service";
        String comp = "userdelegationkey";
        return this.service.getUserDelegationKey(this.client.getUrl(), keyInfo, timeout, this.client.getVersion(), requestId, "service", "userdelegationkey", context);
    }

    public Mono<ServicesGetUserDelegationKeyResponse> getUserDelegationKeyWithRestResponseAsync(KeyInfo keyInfo, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "userdelegationkey";
        return this.service.getUserDelegationKey(this.client.getUrl(), keyInfo, timeout, this.client.getVersion(), requestId, "service", "userdelegationkey", context);
    }

    public Mono<ServicesGetAccountInfoResponse> getAccountInfoWithRestResponseAsync(Context context) {
        String restype = "account";
        String comp = "properties";
        return this.service.getAccountInfo(this.client.getUrl(), this.client.getVersion(), "account", "properties", context);
    }

    public Mono<ServicesSubmitBatchResponse> submitBatchWithRestResponseAsync(Flux<ByteBuffer> body, long contentLength, String multipartContentType, Context context) {
        Integer timeout = null;
        String requestId = null;
        String comp = "batch";
        return this.service.submitBatch(this.client.getUrl(), body, contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, "batch", context);
    }

    public Mono<ServicesSubmitBatchResponse> submitBatchWithRestResponseAsync(Flux<ByteBuffer> body, long contentLength, String multipartContentType, Integer timeout, String requestId, Context context) {
        String comp = "batch";
        return this.service.submitBatch(this.client.getUrl(), body, contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, "batch", context);
    }

    public Mono<ServicesFilterBlobsResponse> filterBlobsWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String requestId = null;
        String where = null;
        String marker = null;
        Integer maxresults = null;
        String comp = "blobs";
        return this.service.filterBlobs(this.client.getUrl(), timeout, this.client.getVersion(), requestId, where, marker, maxresults, "blobs", context);
    }

    public Mono<ServicesFilterBlobsResponse> filterBlobsWithRestResponseAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, Context context) {
        String comp = "blobs";
        return this.service.filterBlobs(this.client.getUrl(), timeout, this.client.getVersion(), requestId, where, marker, maxresults, "blobs", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageServices")
    private static interface ServicesService {
        @Put(value="")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ServicesSetPropertiesResponse> setProperties(@HostParam(value="url") String var1, @BodyParam(value="application/xml; charset=utf-8") BlobServiceProperties var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ServicesGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6, Context var7);

        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ServicesGetStatisticsResponse> getStatistics(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6, Context var7);

        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ServicesListBlobContainersSegmentResponse> listBlobContainersSegment(@HostParam(value="url") String var1, @QueryParam(value="prefix") String var2, @QueryParam(value="marker") String var3, @QueryParam(value="maxresults") Integer var4, @QueryParam(value="include") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, Context var10);

        @Post(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ServicesGetUserDelegationKeyResponse> getUserDelegationKey(@HostParam(value="url") String var1, @BodyParam(value="application/xml; charset=utf-8") KeyInfo var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ServicesGetAccountInfoResponse> getAccountInfo(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, Context var5);

        @Post(value="")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ServicesSubmitBatchResponse> submitBatch(@HostParam(value="url") String var1, @BodyParam(value="application/xml; charset=utf-8") Flux<ByteBuffer> var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, Context var10);

        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ServicesFilterBlobsResponse> filterBlobs(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="where") String var5, @QueryParam(value="marker") String var6, @QueryParam(value="maxresults") Integer var7, @QueryParam(value="comp") String var8, Context var9);
    }
}

