/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad;

import com.azure.spring.aad.AADJwtGrantedAuthoritiesConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.Assert;

public abstract class AbstractJwtBearerTokenAuthenticationConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    public static final String DEFAULT_PRINCIPAL_CLAIM_NAME = "sub";
    protected Converter<Jwt, Collection<GrantedAuthority>> converter;
    protected String principalClaimName;

    public AbstractJwtBearerTokenAuthenticationConverter(String principalClaimName, Map<String, String> claimToAuthorityPrefixMap) {
        Assert.notNull(claimToAuthorityPrefixMap, (String)"claimToAuthorityPrefixMap cannot be null");
        this.principalClaimName = principalClaimName;
        this.converter = new AADJwtGrantedAuthoritiesConverter(claimToAuthorityPrefixMap);
    }

    public AbstractAuthenticationToken convert(Jwt jwt) {
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, jwt.getTokenValue(), jwt.getIssuedAt(), jwt.getExpiresAt());
        Collection authorities = (Collection)this.converter.convert((Object)jwt);
        OAuth2AuthenticatedPrincipal principal = this.getAuthenticatedPrincipal(jwt.getHeaders(), jwt.getClaims(), authorities, jwt.getTokenValue());
        return new BearerTokenAuthentication(principal, accessToken, authorities);
    }

    protected static Map<String, String> buildClaimToAuthorityPrefixMap(String authoritiesClaimName, String authorityPrefix) {
        Assert.notNull((Object)authoritiesClaimName, (String)"authoritiesClaimName cannot be null");
        Assert.notNull((Object)authorityPrefix, (String)"authorityPrefix cannot be null");
        HashMap<String, String> claimToAuthorityPrefixMap = new HashMap<String, String>();
        claimToAuthorityPrefixMap.put(authoritiesClaimName, authorityPrefix);
        return claimToAuthorityPrefixMap;
    }

    protected abstract OAuth2AuthenticatedPrincipal getAuthenticatedPrincipal(Map<String, Object> var1, Map<String, Object> var2, Collection<GrantedAuthority> var3, String var4);

    public void setConverter(Converter<Jwt, Collection<GrantedAuthority>> converter) {
        this.converter = converter;
    }

    public void setPrincipalClaimName(String principalClaimName) {
        Assert.hasText((String)principalClaimName, (String)"principalClaimName cannot be empty");
        this.principalClaimName = principalClaimName;
    }
}

