/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.aad;

import com.azure.spring.aad.AADApplicationType;
import com.azure.spring.aad.AADAuthorizationGrantType;
import com.azure.spring.aad.webapp.AuthorizationClientProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="azure.activedirectory")
public class AADAuthenticationProperties
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADAuthenticationProperties.class);
    private static final long DEFAULT_JWK_SET_CACHE_LIFESPAN;
    private static final long DEFAULT_JWK_SET_CACHE_REFRESH_TIME;
    private UserGroupProperties userGroup = new UserGroupProperties();
    private String clientId;
    private String clientSecret;
    private String userNameAttribute;
    private String redirectUriTemplate;
    private String appIdUri;
    private Map<String, Object> authenticateAdditionalParameters;
    private int jwtConnectTimeout = 500;
    private int jwtReadTimeout = 500;
    private int jwtSizeLimit = 51200;
    private long jwkSetCacheLifespan = DEFAULT_JWK_SET_CACHE_LIFESPAN;
    private long jwkSetCacheRefreshTime = DEFAULT_JWK_SET_CACHE_REFRESH_TIME;
    private String tenantId;
    private String postLogoutRedirectUri;
    private boolean allowTelemetry = true;
    private Boolean sessionStateless = false;
    private String baseUri;
    private String graphBaseUri;
    private String graphMembershipUri;
    private Map<String, AuthorizationClientProperties> authorizationClients = new HashMap<String, AuthorizationClientProperties>();
    private AADApplicationType applicationType;

    public AADApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(AADApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    @DeprecatedConfigurationProperty(reason="Configuration moved to UserGroup class to keep UserGroup properties together", replacement="azure.activedirectory.user-group.allowed-group-names")
    public List<String> getActiveDirectoryGroups() {
        return this.userGroup.getAllowedGroups();
    }

    public boolean allowedGroupNamesConfigured() {
        return Optional.of(this.getUserGroup()).map(UserGroupProperties::getAllowedGroupNames).map(allowedGroupNames -> !allowedGroupNames.isEmpty()).orElse(false);
    }

    public boolean allowedGroupIdsConfigured() {
        return Optional.of(this.getUserGroup()).map(UserGroupProperties::getAllowedGroupIds).map(allowedGroupIds -> !allowedGroupIds.isEmpty()).orElse(false);
    }

    public UserGroupProperties getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(UserGroupProperties userGroup) {
        this.userGroup = userGroup;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public String getRedirectUriTemplate() {
        return this.redirectUriTemplate;
    }

    public void setRedirectUriTemplate(String redirectUriTemplate) {
        this.redirectUriTemplate = redirectUriTemplate;
    }

    @Deprecated
    public void setActiveDirectoryGroups(List<String> activeDirectoryGroups) {
        this.userGroup.setAllowedGroups(activeDirectoryGroups);
    }

    public String getAppIdUri() {
        return this.appIdUri;
    }

    public void setAppIdUri(String appIdUri) {
        this.appIdUri = appIdUri;
    }

    public Map<String, Object> getAuthenticateAdditionalParameters() {
        return this.authenticateAdditionalParameters;
    }

    public void setAuthenticateAdditionalParameters(Map<String, Object> authenticateAdditionalParameters) {
        this.authenticateAdditionalParameters = authenticateAdditionalParameters;
    }

    public int getJwtConnectTimeout() {
        return this.jwtConnectTimeout;
    }

    public void setJwtConnectTimeout(int jwtConnectTimeout) {
        this.jwtConnectTimeout = jwtConnectTimeout;
    }

    public int getJwtReadTimeout() {
        return this.jwtReadTimeout;
    }

    public void setJwtReadTimeout(int jwtReadTimeout) {
        this.jwtReadTimeout = jwtReadTimeout;
    }

    public int getJwtSizeLimit() {
        return this.jwtSizeLimit;
    }

    public void setJwtSizeLimit(int jwtSizeLimit) {
        this.jwtSizeLimit = jwtSizeLimit;
    }

    public long getJwkSetCacheLifespan() {
        return this.jwkSetCacheLifespan;
    }

    public void setJwkSetCacheLifespan(long jwkSetCacheLifespan) {
        this.jwkSetCacheLifespan = jwkSetCacheLifespan;
    }

    public long getJwkSetCacheRefreshTime() {
        return this.jwkSetCacheRefreshTime;
    }

    public void setJwkSetCacheRefreshTime(long jwkSetCacheRefreshTime) {
        this.jwkSetCacheRefreshTime = jwkSetCacheRefreshTime;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Deprecate the telemetry endpoint and use HTTP header User Agent instead.")
    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public void setAllowTelemetry(boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    public Boolean getSessionStateless() {
        return this.sessionStateless;
    }

    public void setSessionStateless(Boolean sessionStateless) {
        this.sessionStateless = sessionStateless;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getGraphBaseUri() {
        return this.graphBaseUri;
    }

    public void setGraphBaseUri(String graphBaseUri) {
        this.graphBaseUri = graphBaseUri;
    }

    public String getGraphMembershipUri() {
        return this.graphMembershipUri;
    }

    public void setGraphMembershipUri(String graphMembershipUri) {
        this.graphMembershipUri = graphMembershipUri;
    }

    public Map<String, AuthorizationClientProperties> getAuthorizationClients() {
        return this.authorizationClients;
    }

    public void setAuthorizationClients(Map<String, AuthorizationClientProperties> authorizationClients) {
        this.authorizationClients = authorizationClients;
    }

    public boolean isAllowedGroup(String group) {
        return Optional.ofNullable(this.getUserGroup()).map(UserGroupProperties::getAllowedGroupNames).orElseGet(Collections::emptyList).contains(group) || Optional.ofNullable(this.getUserGroup()).map(UserGroupProperties::getAllowedGroupIds).orElseGet(Collections::emptySet).contains(group);
    }

    public void afterPropertiesSet() {
        this.baseUri = !StringUtils.hasText((String)this.baseUri) ? "https://login.microsoftonline.com/" : this.addSlash(this.baseUri);
        if (!StringUtils.hasText((String)this.redirectUriTemplate)) {
            this.redirectUriTemplate = "{baseUrl}/login/oauth2/code/";
        }
        this.graphBaseUri = !StringUtils.hasText((String)this.graphBaseUri) ? "https://graph.microsoft.com/" : this.addSlash(this.graphBaseUri);
        if (!StringUtils.hasText((String)this.graphMembershipUri)) {
            this.graphMembershipUri = this.graphBaseUri + "v1.0/me/memberOf";
        }
        if (!this.graphMembershipUri.startsWith(this.graphBaseUri)) {
            throw new IllegalStateException("azure.activedirectory.graph-base-uri should be the prefix of azure.activedirectory.graph-membership-uri. azure.activedirectory.graph-base-uri = " + this.graphBaseUri + ", azure.activedirectory.graph-membership-uri = " + this.graphMembershipUri + ".");
        }
        Set<String> allowedGroupIds = this.userGroup.getAllowedGroupIds();
        if (allowedGroupIds.size() > 1 && allowedGroupIds.contains("all")) {
            throw new IllegalStateException("When azure.activedirectory.user-group.allowed-group-ids contains 'all', no other group ids can be configured. But actually azure.activedirectory.user-group.allowed-group-ids=" + allowedGroupIds);
        }
        this.validateTenantId();
        this.validateApplicationType();
        this.validateClientId();
        this.validateAuthorizationClients();
    }

    private void validateAuthorizationClients() {
        this.authorizationClients.forEach(this::validateAuthorizationClientProperties);
    }

    private void validateClientId() {
        if (!(this.applicationType != AADApplicationType.WEB_APPLICATION && this.applicationType != AADApplicationType.WEB_APPLICATION_AND_RESOURCE_SERVER && this.applicationType != AADApplicationType.RESOURCE_SERVER_WITH_OBO || StringUtils.hasText((String)this.clientId))) {
            throw new IllegalStateException("'azure.activedirectory.client-id' must be configured when application type is 'web_application', 'resource_server_with_obo' or 'web_application_and_resource_server'.");
        }
    }

    private void validateTenantId() {
        if (!StringUtils.hasText((String)this.tenantId)) {
            this.tenantId = "common";
        }
        if (this.isMultiTenantsApplication(this.tenantId) && !this.userGroup.getAllowedGroups().isEmpty()) {
            throw new IllegalStateException("When azure.activedirectory.tenant-id is 'common/organizations/consumers', azure.activedirectory.user-group.allowed-groups/allowed-group-names should be empty. But actually azure.activedirectory.tenant-id=" + this.tenantId + ", and azure.activedirectory.user-group.allowed-groups/allowed-group-names=" + this.userGroup.getAllowedGroups());
        }
        if (this.isMultiTenantsApplication(this.tenantId) && !this.userGroup.getAllowedGroupIds().isEmpty()) {
            throw new IllegalStateException("When azure.activedirectory.tenant-id is 'common/organizations/consumers', azure.activedirectory.user-group.allowed-group-ids should be empty. But actually azure.activedirectory.tenant-id=" + this.tenantId + ", and azure.activedirectory.user-group.allowed-group-ids=" + this.userGroup.getAllowedGroupIds());
        }
    }

    private void validateApplicationType() {
        AADApplicationType inferredType = AADApplicationType.inferApplicationTypeByDependencies();
        if (this.applicationType != null) {
            if (!this.isValidApplicationTypeConfiguration(this.applicationType, inferredType)) {
                throw new IllegalStateException("Invalid property 'azure.activedirectory.application-type', the configured value is '" + this.applicationType.getValue() + "', but the inferred value is '" + inferredType.getValue() + "'.");
            }
        } else {
            this.applicationType = inferredType;
        }
    }

    private boolean isValidApplicationTypeConfiguration(AADApplicationType configured, AADApplicationType inferred) {
        if (configured == inferred) {
            return true;
        }
        return inferred == AADApplicationType.RESOURCE_SERVER_WITH_OBO && configured == AADApplicationType.WEB_APPLICATION_AND_RESOURCE_SERVER;
    }

    private void validateAuthorizationClientProperties(String registrationId, AuthorizationClientProperties properties) {
        block15: {
            String grantType;
            block14: {
                grantType = Optional.of(properties).map(AuthorizationClientProperties::getAuthorizationGrantType).map(AADAuthorizationGrantType::getValue).orElse(null);
                if (null != grantType) break block14;
                switch (this.applicationType) {
                    case WEB_APPLICATION: {
                        properties.setAuthorizationGrantType(AADAuthorizationGrantType.AUTHORIZATION_CODE);
                        LOGGER.debug("The client '{}' sets the default value of AADAuthorizationGrantType to 'authorization_code'.", (Object)registrationId);
                        break block15;
                    }
                    case RESOURCE_SERVER: 
                    case RESOURCE_SERVER_WITH_OBO: {
                        properties.setAuthorizationGrantType(AADAuthorizationGrantType.ON_BEHALF_OF);
                        LOGGER.debug("The client '{}' sets the default value of AADAuthorizationGrantType to 'on_behalf_of'.", (Object)registrationId);
                        break block15;
                    }
                    case WEB_APPLICATION_AND_RESOURCE_SERVER: {
                        throw new IllegalStateException("azure.activedirectory.authorization-clients." + registrationId + ".authorization-grant-grantType must be configured. ");
                    }
                    default: {
                        throw new IllegalStateException("Unsupported authorization grantType " + this.applicationType.getValue());
                    }
                }
            }
            switch (this.applicationType) {
                case WEB_APPLICATION: {
                    if (!AADAuthorizationGrantType.ON_BEHALF_OF.getValue().equals(grantType)) break;
                    throw new IllegalStateException("When 'azure.activedirectory.application-type=web_application', 'azure.activedirectory.authorization-clients." + registrationId + ".authorization-grant-type' can not be 'on_behalf_of'.");
                }
                case RESOURCE_SERVER: {
                    if (AADAuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(grantType)) {
                        throw new IllegalStateException("When 'azure.activedirectory.application-type=resource_server', 'azure.activedirectory.authorization-clients." + registrationId + ".authorization-grant-type' can not be 'authorization_code'.");
                    }
                    if (!AADAuthorizationGrantType.ON_BEHALF_OF.getValue().equals(grantType)) break;
                    throw new IllegalStateException("When 'azure.activedirectory.application-type=resource_server', 'azure.activedirectory.authorization-clients." + registrationId + ".authorization-grant-type' can not be 'on_behalf_of'.");
                }
                case RESOURCE_SERVER_WITH_OBO: {
                    if (!AADAuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(grantType)) break;
                    throw new IllegalStateException("When 'azure.activedirectory.application-type=resource_server_with_obo', 'azure.activedirectory.authorization-clients." + registrationId + ".authorization-grant-type' can not be 'authorization_code'.");
                }
                default: {
                    LOGGER.debug("'azure.activedirectory.authorization-clients." + registrationId + ".authorization-grant-type' is valid.");
                }
            }
            if (properties.isOnDemand() && !AADAuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(grantType)) {
                throw new IllegalStateException("onDemand only support authorization_code grant grantType. Please set 'azure.activedirectory.authorization-clients." + registrationId + ".authorization-grant-grantType=authorization_code' or 'azure.activedirectory.authorization-clients." + registrationId + ".on-demand=false'.");
            }
            if ("azure".equals(registrationId) && !AADAuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)properties.getAuthorizationGrantType())) {
                throw new IllegalStateException("azure.activedirectory.authorization-clients.azure.authorization-grant-grantType must be configured to 'authorization_code'.");
            }
        }
        if (properties.getScopes() == null || properties.getScopes().isEmpty()) {
            throw new IllegalStateException("'azure.activedirectory.authorization-clients." + registrationId + ".scopes' must be configured");
        }
    }

    private boolean isMultiTenantsApplication(String tenantId) {
        return "common".equals(tenantId) || "organizations".equals(tenantId) || "consumers".equals(tenantId);
    }

    private String addSlash(String uri) {
        return uri.endsWith("/") ? uri : uri + "/";
    }

    static {
        DEFAULT_JWK_SET_CACHE_REFRESH_TIME = DEFAULT_JWK_SET_CACHE_LIFESPAN = TimeUnit.MINUTES.toMillis(5L);
    }

    public static class UserGroupProperties {
        private final Log logger = LogFactory.getLog(UserGroupProperties.class);
        private List<String> allowedGroupNames = new ArrayList<String>();
        private Set<String> allowedGroupIds = new HashSet<String>();
        private Boolean enableFullList = false;

        public Set<String> getAllowedGroupIds() {
            return this.allowedGroupIds;
        }

        public void setAllowedGroupIds(Set<String> allowedGroupIds) {
            this.allowedGroupIds = allowedGroupIds;
        }

        public List<String> getAllowedGroupNames() {
            return this.allowedGroupNames;
        }

        public void setAllowedGroupNames(List<String> allowedGroupNames) {
            this.allowedGroupNames = allowedGroupNames;
        }

        @Deprecated
        @DeprecatedConfigurationProperty(reason="enable-full-list is not easy to understand.", replacement="allowed-group-ids: all")
        public Boolean getEnableFullList() {
            return this.enableFullList;
        }

        @Deprecated
        public void setEnableFullList(Boolean enableFullList) {
            this.logger.warn((Object)" 'azure.activedirectory.user-group.enable-full-list' property detected! Use 'azure.activedirectory.user-group.allowed-group-ids: all' instead!");
            this.enableFullList = enableFullList;
        }

        @Deprecated
        @DeprecatedConfigurationProperty(reason="In order to distinguish between allowed-group-ids and allowed-group-names, set allowed-groups deprecated.", replacement="azure.activedirectory.user-group.allowed-group-names")
        public List<String> getAllowedGroups() {
            return this.allowedGroupNames;
        }

        @Deprecated
        public void setAllowedGroups(List<String> allowedGroups) {
            this.logger.warn((Object)" 'azure.activedirectory.user-group.allowed-groups' property detected!  Use 'azure.activedirectory.user-group.allowed-group-names' instead!");
            this.allowedGroupNames = allowedGroups;
        }
    }
}

