/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.condition.aad;

import com.azure.spring.aad.AADApplicationType;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public final class ClientRegistrationCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"AAD Application Client Condition", (Object[])new Object[0]);
        AADAuthenticationProperties properties = (AADAuthenticationProperties)Binder.get((Environment)context.getEnvironment()).bind("azure.activedirectory", AADAuthenticationProperties.class).orElse(null);
        if (properties == null) {
            return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("AAD authorization properties(azure.activedirectory.xxx)"));
        }
        if (!StringUtils.hasText((String)properties.getClientId())) {
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("azure.activedirectory.client-id").atAll());
        }
        AADApplicationType applicationType = Optional.ofNullable(properties.getApplicationType()).orElseGet(AADApplicationType::inferApplicationTypeByDependencies);
        if (applicationType == null || applicationType == AADApplicationType.RESOURCE_SERVER) {
            return ConditionOutcome.noMatch((ConditionMessage)message.because("Resource server does not need client registration."));
        }
        return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)("azure.activedirectory.application-type=" + (Object)((Object)applicationType))));
    }
}

