/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.factory.credential;

import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.spring.cloud.core.implementation.factory.credential.AzureAadCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.authentication.TokenCredentialOptionsProvider;

public class ClientSecretCredentialBuilderFactory
extends AzureAadCredentialBuilderFactory<ClientSecretCredentialBuilder> {
    public ClientSecretCredentialBuilderFactory(AzureProperties azureProperties) {
        super(azureProperties);
    }

    @Override
    protected ClientSecretCredentialBuilder createBuilderInstance() {
        return new ClientSecretCredentialBuilder();
    }

    @Override
    protected void configureService(ClientSecretCredentialBuilder builder) {
        super.configureService(builder);
        AzureProperties azureProperties = this.getAzureProperties();
        TokenCredentialOptionsProvider.TokenCredentialOptions credential = azureProperties.getCredential();
        PropertyMapper map = new PropertyMapper();
        map.from(credential.getClientSecret()).to(arg_0 -> ((ClientSecretCredentialBuilder)builder).clientSecret(arg_0));
    }
}

