/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.properties.profile;

import com.azure.core.management.AzureEnvironment;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.properties.profile.AzureEnvironmentProperties;
import com.azure.spring.cloud.core.provider.AzureProfileOptionsProvider;
import org.springframework.beans.BeanUtils;

public abstract class AzureProfileOptionsAdapter
implements AzureProfileOptionsProvider.ProfileOptions {
    protected void changeEnvironmentAccordingToCloud() {
        if (this.getCloudType() == null) {
            BeanUtils.copyProperties((Object)new AzureEnvironmentProperties(), (Object)this.getEnvironment());
        } else {
            AzureProfileOptionsProvider.AzureEnvironmentOptions defaultEnvironment = this.decideAzureEnvironment(this.getCloudType(), new AzureEnvironmentProperties());
            AzurePropertiesUtils.copyPropertiesIgnoreNull(defaultEnvironment, this.getEnvironment());
        }
    }

    @Override
    public abstract AzureProfileOptionsProvider.AzureEnvironmentOptions getEnvironment();

    private AzureProfileOptionsProvider.AzureEnvironmentOptions decideAzureEnvironment(AzureProfileOptionsProvider.CloudType cloudType, AzureProfileOptionsProvider.AzureEnvironmentOptions defaultEnvironment) {
        switch (cloudType) {
            case AZURE_CHINA: {
                return AzureEnvironmentProperties.AZURE_CHINA;
            }
            case AZURE_US_GOVERNMENT: {
                return AzureEnvironmentProperties.AZURE_US_GOVERNMENT;
            }
            case AZURE_GERMANY: {
                return AzureEnvironmentProperties.AZURE_GERMANY;
            }
            case AZURE: {
                return AzureEnvironmentProperties.AZURE;
            }
        }
        return defaultEnvironment;
    }

    public static AzureEnvironment decideAzureManagementEnvironment(AzureProfileOptionsProvider.CloudType cloudType, AzureEnvironment defaultManagementEnvironment) {
        switch (cloudType) {
            case AZURE_CHINA: {
                return AzureEnvironment.AZURE_CHINA;
            }
            case AZURE_US_GOVERNMENT: {
                return AzureEnvironment.AZURE_US_GOVERNMENT;
            }
            case AZURE_GERMANY: {
                return AzureEnvironment.AZURE_GERMANY;
            }
            case AZURE: {
                return AzureEnvironment.AZURE;
            }
        }
        return defaultManagementEnvironment;
    }
}

