/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public final class RuntimeHintsUtils {
    private static final Log LOGGER = LogFactory.getLog(RuntimeHintsUtils.class);

    private RuntimeHintsUtils() {
    }

    public static List<Class> findTypes(String basePackage, ClassLoader classLoader) throws IOException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(classLoader);
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        ArrayList<Class> candidates = new ArrayList<Class>();
        String packageSearchPath = "classpath*:" + RuntimeHintsUtils.resolveBasePackage(basePackage) + "/**/*.class";
        for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
            MetadataReader metadataReader;
            String className;
            if (!resource.isReadable() || (className = (metadataReader = metadataReaderFactory.getMetadataReader(resource)).getClassMetadata().getClassName()).endsWith("1") || className.endsWith("2")) continue;
            LOGGER.debug((Object)("Will register class: " + className));
            try {
                Class<?> e = Class.forName(className);
                candidates.add(e);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.error((Object)"Class not found", (Throwable)ex);
            }
            catch (AssertionError e) {
                LOGGER.error((Object)"Assertion error happens", (Throwable)((Object)e));
            }
        }
        return candidates;
    }

    private static String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }
}

