/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.factory.credential;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.identity.CredentialBuilderBase;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureHttpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.properties.AzureProperties;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzureCredentialBuilderFactory<T extends CredentialBuilderBase<T>>
extends AbstractAzureHttpClientBuilderFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAzureCredentialBuilderFactory.class);
    private final AzureProperties azureProperties;

    protected AbstractAzureCredentialBuilderFactory(AzureProperties azureProperties) {
        this.azureProperties = azureProperties;
        this.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_IDENTITY);
    }

    @Override
    protected BiConsumer<T, HttpClient> consumeHttpClient() {
        return CredentialBuilderBase::httpClient;
    }

    @Override
    protected BiConsumer<T, HttpPipeline> consumeHttpPipeline() {
        return CredentialBuilderBase::pipeline;
    }

    @Override
    protected AzureProperties getAzureProperties() {
        return this.azureProperties;
    }

    @Override
    protected BiConsumer<T, Configuration> consumeConfiguration() {
        return CredentialBuilderBase::configuration;
    }

    @Override
    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(T builder) {
        return Collections.emptyList();
    }

    @Override
    protected BiConsumer<T, ClientOptions> consumeClientOptions() {
        return CredentialBuilderBase::clientOptions;
    }

    @Override
    protected BiConsumer<T, TokenCredential> consumeDefaultTokenCredential() {
        return (a, b) -> {};
    }

    @Override
    protected BiConsumer<T, String> consumeConnectionString() {
        return (a, b) -> {};
    }

    @Override
    protected BiConsumer<T, HttpLogOptions> consumeHttpLogOptions() {
        return CredentialBuilderBase::httpLogOptions;
    }

    @Override
    protected BiConsumer<T, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return CredentialBuilderBase::addPolicy;
    }

    @Override
    protected BiConsumer<T, RetryPolicy> consumeRetryPolicy() {
        return CredentialBuilderBase::retryPolicy;
    }

    @Override
    protected void configureService(T builder) {
    }
}

