/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.properties;

import com.azure.identity.extensions.implementation.enums.AuthProperty;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;

public enum AzurePasswordlessPropertiesMapping {
    SCOPES(p -> p.getScopes(), (p, s) -> p.setProperty(AuthProperty.SCOPES.getPropertyKey(), (String)s)),
    CLIENT_CERTIFICATE_PASSWORD(p -> p.getCredential().getClientCertificatePassword(), (p, s) -> p.setProperty(AuthProperty.CLIENT_CERTIFICATE_PASSWORD.getPropertyKey(), (String)s)),
    CLIENT_CERTIFICATE_PATH(p -> p.getCredential().getClientCertificatePath(), (p, s) -> p.setProperty(AuthProperty.CLIENT_CERTIFICATE_PATH.getPropertyKey(), (String)s)),
    CLIENT_ID(p -> p.getCredential().getClientId(), (p, s) -> p.setProperty(AuthProperty.CLIENT_ID.getPropertyKey(), (String)s)),
    CLIENT_SECRET(p -> p.getCredential().getClientSecret(), (p, s) -> p.setProperty(AuthProperty.CLIENT_SECRET.getPropertyKey(), (String)s)),
    MANAGED_IDENTITY_ENABLED(p -> String.valueOf(p.getCredential().isManagedIdentityEnabled()), (p, s) -> p.setProperty(AuthProperty.MANAGED_IDENTITY_ENABLED.getPropertyKey(), (String)s)),
    PASSWORD(p -> p.getCredential().getPassword(), (p, s) -> p.setProperty(AuthProperty.PASSWORD.getPropertyKey(), (String)s)),
    USERNAME(p -> p.getCredential().getUsername(), (p, s) -> p.setProperty(AuthProperty.USERNAME.getPropertyKey(), (String)s)),
    TENANT_ID(p -> p.getProfile().getTenantId(), (p, s) -> p.setProperty(AuthProperty.TENANT_ID.getPropertyKey(), (String)s)),
    AUTHORITY_HOST(p -> p.getProfile().getEnvironment().getActiveDirectoryEndpoint(), (p, s) -> p.setProperty(AuthProperty.AUTHORITY_HOST.getPropertyKey(), (String)s));

    private Function<PasswordlessProperties, String> getter;
    private BiConsumer<Properties, String> setter;

    public Function<PasswordlessProperties, String> getGetter() {
        return this.getter;
    }

    public BiConsumer<Properties, String> getSetter() {
        return this.setter;
    }

    private AzurePasswordlessPropertiesMapping(Function<PasswordlessProperties, String> getter, BiConsumer<Properties, String> setter) {
        this.getter = getter;
        this.setter = setter;
    }
}

