/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.config;

import com.baidu.disconf.client.config.inner.DisInnerConfigAnnotation;
import com.baidu.disconf.client.support.DisconfAutowareConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DisClientConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisClientConfig.class);
    protected static final DisClientConfig INSTANCE = new DisClientConfig();
    protected static final String filename = "disconf.properties";
    private static final String DISCONF_CONF_FILE_PATH_ARG = "disconf.conf";
    private boolean isLoaded = false;
    public static final String CONF_SERVER_HOST_NAME = "disconf.conf_server_host";
    @DisInnerConfigAnnotation(name="disconf.conf_server_host")
    public String CONF_SERVER_HOST;
    private List<String> hostList;
    public static final String APP_NAME = "disconf.app";
    @DisInnerConfigAnnotation(name="disconf.app")
    public String APP;
    public static final String VERSION_NAME = "disconf.version";
    @DisInnerConfigAnnotation(name="disconf.version", defaultValue="DEFAULT_VERSION")
    public String VERSION = "DEFAULT_VERSION";
    @DisInnerConfigAnnotation(name="disconf.maintype")
    public String MAIN_TYPE;
    public static final String ENV_NAME = "disconf.env";
    @DisInnerConfigAnnotation(name="disconf.env", defaultValue="DEFAULT_ENV")
    public String ENV = "DEFAULT_ENV";
    private static final String ENABLE_REMOTE_CONF_NAME = "disconf.enable.remote.conf";
    @DisInnerConfigAnnotation(name="disconf.enable.remote.conf", defaultValue="false")
    public boolean ENABLE_DISCONF = false;
    @DisInnerConfigAnnotation(name="disconf.debug", defaultValue="false")
    public boolean DEBUG = false;
    @DisInnerConfigAnnotation(name="disconf.ignore", defaultValue="")
    public String IGNORE_DISCONF_LIST = "";
    private Set<String> ignoreDisconfKeySet = new HashSet<String>();
    @DisInnerConfigAnnotation(name="disconf.conf_server_url_retry_times", defaultValue="3")
    public int CONF_SERVER_URL_RETRY_TIMES = 3;
    @DisInnerConfigAnnotation(name="disconf.user_define_download_dir", defaultValue="./disconf/download")
    public String userDefineDownloadDir = "./disconf/download";
    @DisInnerConfigAnnotation(name="disconf.conf_server_url_retry_sleep_seconds", defaultValue="2")
    public int confServerUrlRetrySleepSeconds = 2;
    @DisInnerConfigAnnotation(name="disconf.enable_local_download_dir_in_class_path", defaultValue="true")
    public boolean enableLocalDownloadDirInClassPath = true;

    public static DisClientConfig getInstance() {
        return INSTANCE;
    }

    private DisClientConfig() {
    }

    public synchronized boolean isLoaded() {
        return this.isLoaded;
    }

    public synchronized void loadConfig(String filePath) throws Exception {
        String disconfFilePath;
        if (this.isLoaded) {
            return;
        }
        String filePathInternal = filename;
        if (filePath != null) {
            filePathInternal = filePath;
        }
        if ((disconfFilePath = System.getProperty(DISCONF_CONF_FILE_PATH_ARG)) != null) {
            filePathInternal = disconfFilePath;
        }
        try {
            DisconfAutowareConfig.autowareConfig((Object)INSTANCE, filePathInternal);
        }
        catch (Exception e) {
            LOGGER.warn("cannot find " + filePathInternal + ", using sys var or user input.");
        }
        DisconfAutowareConfig.autowareConfigWithSystemEnv(INSTANCE);
        this.isLoaded = true;
    }

    public List<String> getHostList() {
        return this.hostList;
    }

    public void setHostList(List<String> hostList) {
        this.hostList = hostList;
    }

    public Set<String> getIgnoreDisconfKeySet() {
        return this.ignoreDisconfKeySet;
    }

    public void setIgnoreDisconfKeySet(Set<String> ignoreDisconfKeySet) {
        this.ignoreDisconfKeySet = ignoreDisconfKeySet;
    }
}

