/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.concurrent;

import com.baidu.hugegraph.concurrent.LockManager;
import com.baidu.hugegraph.util.Log;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class AtomicLock {
    private static final Logger LOG = Log.logger(LockManager.class);
    private String name;
    private AtomicReference<Thread> sign;

    public AtomicLock(String name) {
        this.name = name;
        this.sign = new AtomicReference();
    }

    public boolean tryLock() {
        Thread current = Thread.currentThread();
        return this.sign.compareAndSet(null, current);
    }

    public void unlock() {
        Thread current = Thread.currentThread();
        if (!this.sign.compareAndSet(current, null)) {
            throw new RuntimeException(String.format("Thread '%s' trying to unlock '%s' which is held by other threads now.", current.getName(), this.name));
        }
    }

    public boolean lock(int retries) {
        if (retries < 0 || retries > 10) {
            throw new IllegalArgumentException(String.format("Locking retry times should be in [0, 10], but got %d", retries));
        }
        boolean isLocked = false;
        try {
            for (int i = 0; !(isLocked = this.tryLock()) && i < retries; ++i) {
                Thread.sleep(1000L * (1L << i));
            }
        }
        catch (InterruptedException ignored) {
            LOG.info("Thread sleep is interrupted.");
        }
        return isLocked;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }
}

