/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.concurrent;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class KeyLock {
    private Striped<Lock> locks;

    public KeyLock() {
        this(Runtime.getRuntime().availableProcessors() << 2);
    }

    public KeyLock(int size) {
        this.locks = Striped.lock((int)size);
    }

    private int indexOf(Lock lock) {
        for (int i = 0; i < this.locks.size(); ++i) {
            if (this.locks.getAt(i) != lock) continue;
            return i;
        }
        return -1;
    }

    public final Lock lock(Object key) {
        Lock lock = (Lock)this.locks.get(key);
        lock.lock();
        return lock;
    }

    public final void unlock(Object key) {
        ((Lock)this.locks.get(key)).unlock();
    }

    public final List<Lock> lockAll(Object ... keys) {
        ArrayList<Lock> locks = new ArrayList<Lock>(keys.length);
        for (Object key : keys) {
            Lock lock = (Lock)this.locks.get(key);
            locks.add(lock);
        }
        Collections.sort(locks, (a, b) -> {
            int diff = a.hashCode() - b.hashCode();
            if (diff == 0 && a != b) {
                diff = this.indexOf((Lock)a) - this.indexOf((Lock)b);
                assert (diff != 0);
            }
            return diff;
        });
        for (int i = 0; i < locks.size(); ++i) {
            ((Lock)locks.get(i)).lock();
        }
        return Collections.unmodifiableList(locks);
    }

    public List<Lock> lockAll(Object key1, Object key2) {
        Lock lock1 = (Lock)this.locks.get(key1);
        Lock lock2 = (Lock)this.locks.get(key2);
        int diff = lock1.hashCode() - lock2.hashCode();
        if (diff == 0 && lock1 != lock2) {
            diff = this.indexOf(lock1) - this.indexOf(lock2);
            assert (diff != 0);
        }
        ImmutableList locks = diff > 0 ? ImmutableList.of((Object)lock2, (Object)lock1) : ImmutableList.of((Object)lock1, (Object)lock2);
        for (int i = 0; i < locks.size(); ++i) {
            ((Lock)locks.get(i)).lock();
        }
        return locks;
    }

    public final void unlockAll(List<Lock> locks) {
        for (int i = locks.size(); i > 0; --i) {
            assert (this.indexOf(locks.get(i - 1)) != -1);
            locks.get(i - 1).unlock();
        }
    }
}

