/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.concurrent;

import com.baidu.hugegraph.concurrent.LockGroup;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LockManager {
    private static final LockManager INSTANCE = new LockManager();
    private Map<String, LockGroup> lockGroupMap = new ConcurrentHashMap<String, LockGroup>();

    public static LockManager instance() {
        return INSTANCE;
    }

    private LockManager() {
    }

    public boolean exists(String group) {
        return this.lockGroupMap.containsKey(group);
    }

    public LockGroup create(String group) {
        if (this.lockGroupMap.containsKey(group)) {
            throw new RuntimeException(String.format("LockGroup '%s' already exists!", group));
        }
        LockGroup lockGroup = new LockGroup(group);
        this.lockGroupMap.putIfAbsent(group, lockGroup);
        return lockGroup;
    }

    public LockGroup get(String group) {
        if (!this.exists(group)) {
            throw new RuntimeException(String.format("LockGroup '%s' does not exists", group));
        }
        return this.lockGroupMap.get(group);
    }

    public void destroy(String group) {
        if (!this.exists(group)) {
            throw new RuntimeException(String.format("LockGroup '%s' does not exists", group));
        }
        this.lockGroupMap.remove(group);
    }
}

