/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.config;

import com.baidu.hugegraph.config.ConfigException;
import com.baidu.hugegraph.config.ConfigOption;
import com.baidu.hugegraph.util.E;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConfigListOption<T>
extends ConfigOption<List<T>> {
    private final Class<T> elemClass;

    public ConfigListOption(String name, String desc, Predicate<List<T>> func, T value) {
        this(name, false, desc, func, value.getClass(), new Object[]{value});
    }

    public ConfigListOption(String name, boolean required, String desc, Predicate<List<T>> func, Class<T> clazz, T ... values) {
        this(name, required, desc, func, clazz, Arrays.asList(values));
    }

    public ConfigListOption(String name, boolean required, String desc, Predicate<List<T>> func, Class<T> clazz, List<T> values) {
        super(name, required, desc, func, values.getClass(), values);
        E.checkArgumentNotNull(clazz, "Element class can't be null", new Object[0]);
        this.elemClass = clazz;
    }

    @Override
    public List<T> convert(Object value) {
        String str = (String)value;
        if (!str.startsWith("[") || !str.endsWith("]")) {
            throw new ConfigException("The list type config option expected to be wrapped in [], actual '%s'", str);
        }
        str = str.substring(1, str.length() - 1);
        String[] parts = str.split(",");
        ArrayList<Object> results = new ArrayList<Object>(parts.length);
        for (String part : parts) {
            results.add(super.convert(part.trim(), this.elemClass));
        }
        return results;
    }
}

