/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.config;

import com.baidu.hugegraph.config.ConfigException;
import com.baidu.hugegraph.config.ConfigListOption;
import com.baidu.hugegraph.config.ConfigOption;
import com.baidu.hugegraph.config.OptionSpace;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;

public class HugeConfig
extends PropertiesConfiguration {
    private static final Logger LOG = Log.logger(HugeConfig.class);

    public HugeConfig(Configuration config) {
        if (config == null) {
            throw new ConfigException("The config object is null");
        }
        this.reloadIfNeed(config);
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.contains("..")) {
                key = key.replace("..", ".");
            }
            this.addProperty(key, config.getProperty(key));
        }
        this.checkRequiredOptions();
    }

    public HugeConfig(String configFile) {
        this((Configuration)HugeConfig.loadConfigFile(configFile));
    }

    private void reloadIfNeed(Configuration conf) {
        if (!(conf instanceof AbstractFileConfiguration)) {
            return;
        }
        AbstractFileConfiguration fileConfig = (AbstractFileConfiguration)conf;
        File file = fileConfig.getFile();
        if (file != null) {
            this.setFile(file);
        }
        if (!fileConfig.isDelimiterParsingDisabled()) {
            fileConfig.setDelimiterParsingDisabled(true);
            try {
                fileConfig.refresh();
            }
            catch (ConfigurationException e) {
                throw new ConfigException("Unable to load config file: %s", (Throwable)e, file);
            }
        }
    }

    private static PropertiesConfiguration loadConfigFile(String path) {
        E.checkNotNull(path, "config path");
        E.checkArgument(!path.isEmpty(), "The config path can't be empty", new Object[0]);
        File file = new File(path);
        E.checkArgument(file.exists() && file.isFile() && file.canRead(), "Need to specify a readable config, but got: %s", file.toString());
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setDelimiterParsingDisabled(true);
        try {
            config.load(file);
        }
        catch (ConfigurationException e) {
            throw new ConfigException("Unable to load config: %s", (Throwable)e, path);
        }
        return config;
    }

    public <T> T get(ConfigOption<T> option) {
        Object value = this.getProperty(option.name());
        return (T)(value != null ? value : option.defaultValue());
    }

    public Map<String, String> getMap(ConfigListOption<String> option) {
        List values = (List)((Object)this.get(option));
        HashMap<String, String> result = new HashMap<String, String>();
        for (String value : values) {
            String[] pair = value.split(":", 2);
            E.checkState(pair.length == 2, "Invalid option format for '%s': %s(expect KEY:VALUE)", option.name(), value);
            result.put(pair[0].trim(), pair[1].trim());
        }
        return result;
    }

    public void addProperty(String key, Object value) {
        if (!OptionSpace.containKey(key).booleanValue()) {
            LOG.warn("The config option '{}' is redundant, please ensure it has been registered", (Object)key);
        } else {
            value = this.validateOption(key, value);
        }
        super.addPropertyDirect(key, value);
    }

    private Object validateOption(String key, Object value) {
        E.checkArgument(value instanceof String, "Invalid value for key '%s': %s", key, value);
        ConfigOption<?> option = OptionSpace.get(key);
        Class<?> dataType = option.dataType();
        if (List.class.isAssignableFrom(dataType)) {
            E.checkState(option instanceof ConfigListOption, "List option must be registered with class ConfigListOption", new Object[0]);
        }
        value = option.convert(value);
        option.check(value);
        return value;
    }

    private void checkRequiredOptions() {
    }
}

