/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.config;

import com.google.common.base.Predicate;
import java.lang.reflect.Array;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class OptionChecker {
    public static <O> Predicate<O> disallowEmpty() {
        return new Predicate<O>(){

            public boolean apply(@Nullable O o) {
                if (o == null) {
                    return false;
                }
                if (o instanceof String) {
                    return StringUtils.isNotBlank((CharSequence)((String)o));
                }
                if (o.getClass().isArray() && Array.getLength(o) == 0) {
                    return false;
                }
                return !(o instanceof Iterable) || ((Iterable)o).iterator().hasNext();
            }
        };
    }

    public static <O> Predicate<O> allowValues(final O ... values) {
        return new Predicate<O>(){

            public boolean apply(@Nullable O o) {
                return o != null && Arrays.asList(values).contains(o);
            }
        };
    }

    public static <N extends Number> Predicate<N> positiveInt() {
        return new Predicate<N>(){

            public boolean apply(@Nullable N number) {
                return number != null && ((Number)number).longValue() > 0L;
            }
        };
    }

    public static <N extends Number> Predicate<N> nonNegativeInt() {
        return new Predicate<N>(){

            public boolean apply(@Nullable N number) {
                return number != null && ((Number)number).longValue() >= 0L;
            }
        };
    }

    public static <N extends Number> Predicate<N> rangeInt(final N min, final N max) {
        return new Predicate<N>(){

            public boolean apply(@Nullable N number) {
                if (number == null) {
                    return false;
                }
                long value = ((Number)number).longValue();
                return value >= min.longValue() && value <= max.longValue();
            }
        };
    }

    public static <N extends Number> Predicate<N> rangeDouble(final N min, final N max) {
        return new Predicate<N>(){

            public boolean apply(@Nullable N number) {
                if (number == null) {
                    return false;
                }
                double value = ((Number)number).doubleValue();
                return value >= min.doubleValue() && value <= max.doubleValue();
            }
        };
    }
}

