/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.iterator;

import com.baidu.hugegraph.iterator.WrappedIterator;
import com.baidu.hugegraph.util.E;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;

public class ExtendableIterator<T>
extends WrappedIterator<T> {
    private final Deque<Iterator<T>> itors = new ConcurrentLinkedDeque<Iterator<T>>();
    private final List<Iterator<T>> removedItors = new ArrayList<Iterator<T>>();
    private Iterator<T> currentIterator = null;

    public ExtendableIterator() {
    }

    public ExtendableIterator(Iterator<T> iter) {
        this();
        this.extend(iter);
    }

    public ExtendableIterator(Iterator<T> itor1, Iterator<T> itor2) {
        this();
        this.extend(itor1);
        this.extend(itor2);
    }

    public ExtendableIterator<T> extend(Iterator<T> iter) {
        E.checkState(this.currentIterator == null, "Can't extend iterator after iterating", new Object[0]);
        if (iter != null) {
            this.itors.addLast(iter);
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        for (Iterator<T> iter : this.removedItors) {
            if (!(iter instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)iter)).close();
        }
        for (Iterator<T> iter : this.itors) {
            if (!(iter instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)iter)).close();
        }
    }

    @Override
    protected Iterator<?> originIterator() {
        return this.currentIterator;
    }

    @Override
    protected boolean fetch() {
        assert (this.current == ExtendableIterator.none());
        if (this.itors.isEmpty()) {
            return false;
        }
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            this.current = this.currentIterator.next();
            return true;
        }
        Iterator<T> first = null;
        while ((first = this.itors.peekFirst()) != null && !first.hasNext()) {
            if (first == this.itors.peekLast() && this.itors.size() == 1) {
                this.currentIterator = first;
                return false;
            }
            this.removedItors.add(this.itors.removeFirst());
        }
        assert (first != null && first.hasNext());
        this.currentIterator = first;
        this.current = this.currentIterator.next();
        return true;
    }
}

