/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.iterator;

import com.baidu.hugegraph.iterator.WrappedIterator;
import java.util.Iterator;
import java.util.function.Function;

public class FilterIterator<T>
extends WrappedIterator<T> {
    private final Iterator<T> originIterator;
    private final Function<T, Boolean> filterCallback;

    public FilterIterator(Iterator<T> origin, Function<T, Boolean> filter) {
        this.originIterator = origin;
        this.filterCallback = filter;
    }

    @Override
    protected Iterator<T> originIterator() {
        return this.originIterator;
    }

    @Override
    protected final boolean fetch() {
        while (this.originIterator.hasNext()) {
            T next = this.originIterator.next();
            if (next == null || !this.filterCallback.apply(next).booleanValue()) continue;
            assert (this.current == FilterIterator.none());
            this.current = next;
            return true;
        }
        return false;
    }
}

