/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.iterator;

import com.baidu.hugegraph.iterator.WrappedIterator;
import com.baidu.hugegraph.util.E;
import java.util.Iterator;
import java.util.function.Function;

public class FlatMapperIterator<T, R>
extends WrappedIterator<R> {
    private final Iterator<T> originIterator;
    private final Function<T, Iterator<R>> mapperCallback;
    protected Iterator<R> results;

    public FlatMapperIterator(Iterator<T> origin, Function<T, Iterator<R>> mapper) {
        this.originIterator = origin;
        this.mapperCallback = mapper;
        this.results = null;
    }

    @Override
    protected Iterator<?> originIterator() {
        return this.originIterator;
    }

    @Override
    protected final boolean fetch() {
        if (this.results != null && this.fetchMapped()) {
            return true;
        }
        while (this.originIterator.hasNext()) {
            T next = this.originIterator.next();
            assert (this.results == null);
            this.results = this.mapperCallback.apply(next);
            if (this.results == null || !this.fetchMapped()) continue;
            return true;
        }
        return false;
    }

    protected boolean fetchMapped() {
        E.checkNotNull(this.results, "mapper results");
        while (this.results.hasNext()) {
            R result = this.results.next();
            if (result == null) continue;
            assert (this.current == FlatMapperIterator.none());
            this.current = result;
            return true;
        }
        this.results = null;
        return false;
    }
}

