/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.testutil;

import com.baidu.hugegraph.testutil.Assert;
import java.lang.reflect.Field;

public class Whitebox {
    public static void setInternalState(Object target, String fieldName, Object value) {
        try {
            Field f = Whitebox.getFieldFromHierarchy(target.getClass(), fieldName);
            f.setAccessible(true);
            f.set(target, value);
        }
        catch (Exception e) {
            Assert.fail((String)String.format("Can't change value of '%s' against target '%s': %s", fieldName, target, e));
        }
    }

    public static Object getInternalState(Object target, String field) {
        Class<?> c = target.getClass();
        try {
            Field f = Whitebox.getFieldFromHierarchy(c, field);
            f.setAccessible(true);
            return f.get(target);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set internal state on a private field. Please report to mockito mailing list.", e);
        }
    }

    private static Field getFieldFromHierarchy(Class<?> clazz, String field) {
        Field f = Whitebox.getField(clazz, field);
        while (f == null && clazz != Object.class) {
            clazz = clazz.getSuperclass();
            f = Whitebox.getField(clazz, field);
        }
        if (f == null) {
            throw new RuntimeException(String.format("You want to set value to field '%s' on class '%s' but this field is not declared in the class!", field, clazz.getSimpleName()));
        }
        return f;
    }

    private static Field getField(Class<?> clazz, String field) {
        try {
            return clazz.getDeclaredField(field);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

