/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.google.common.primitives.UnsignedBytes;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public final class Bytes {
    public static final long BASE = 1024L;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    private static final Comparator<byte[]> CMP = UnsignedBytes.lexicographicalComparator();

    public static int compare(byte[] bytes1, byte[] bytes2) {
        return CMP.compare(bytes1, bytes2);
    }

    public static byte[] concat(byte[] bytes1, byte[] bytes2) {
        byte[] result = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, result, 0, bytes1.length);
        System.arraycopy(bytes2, 0, result, bytes1.length, bytes2.length);
        return result;
    }

    public static boolean prefixWith(byte[] bytes, byte[] prefix) {
        if (bytes.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (bytes[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] bytes1, byte[] bytes2) {
        return Arrays.equals(bytes1, bytes2);
    }

    public static String toHex(byte[] bytes) {
        return new String(Hex.encodeHex((byte[])bytes));
    }

    public static byte[] fromHex(String hex) {
        try {
            return Hex.decodeHex((char[])hex.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException("Failed to decode hex: " + hex, e);
        }
    }
}

