/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.function.Function;

public final class NumericUtil {
    private NumericUtil() {
    }

    public static long doubleToSortableLong(double val) {
        return NumericUtil.sortableDoubleBits(Double.doubleToLongBits(val));
    }

    public static double sortableLongToDouble(long val) {
        return Double.longBitsToDouble(NumericUtil.sortableDoubleBits(val));
    }

    public static int floatToSortableInt(float val) {
        return NumericUtil.sortableFloatBits(Float.floatToIntBits(val));
    }

    public static float sortableIntToFloat(int val) {
        return Float.intBitsToFloat(NumericUtil.sortableFloatBits(val));
    }

    public static long sortableDoubleBits(long bits) {
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    public static int sortableFloatBits(int bits) {
        return bits ^ bits >> 31 & Integer.MAX_VALUE;
    }

    public static long numberToSortableLong(Number number) {
        if (number instanceof Double) {
            return NumericUtil.doubleToSortableLong(number.doubleValue());
        }
        if (number instanceof Float) {
            return NumericUtil.floatToSortableInt(number.floatValue());
        }
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return number.longValue();
        }
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            boolean intNumber = bd.stripTrailingZeros().scale() <= 0;
            return intNumber ? bd.longValueExact() : NumericUtil.doubleToSortableLong(bd.doubleValue());
        }
        throw new IllegalArgumentException(String.format("Unsupported number type: %s(%s)", number.getClass().getSimpleName(), number));
    }

    public static Number sortableLongToNumber(long value, Class<?> clazz) {
        assert (NumericUtil.isNumber(clazz));
        if (clazz == Double.class) {
            return NumericUtil.sortableLongToDouble(value);
        }
        if (clazz == Float.class) {
            return Float.valueOf(NumericUtil.sortableIntToFloat((int)value));
        }
        if (clazz == Long.class) {
            return value;
        }
        if (clazz == Integer.class) {
            return (int)value;
        }
        if (clazz == Short.class) {
            return (short)value;
        }
        if (clazz == Byte.class) {
            return (byte)value;
        }
        throw new IllegalArgumentException(String.format("Unsupported number type: %s", clazz.getSimpleName()));
    }

    public static byte[] numberToSortableBytes(Number number) {
        if (number instanceof Long) {
            return NumericUtil.longToBytes(number.longValue());
        }
        if (number instanceof Double) {
            return NumericUtil.longToBytes(NumericUtil.doubleToSortableLong(number.doubleValue()));
        }
        if (number instanceof Float) {
            return NumericUtil.intToBytes(NumericUtil.floatToSortableInt(number.floatValue()));
        }
        if (number instanceof Integer || number instanceof Short) {
            return NumericUtil.intToBytes(number.intValue());
        }
        if (number instanceof Byte) {
            return new byte[]{number.byteValue()};
        }
        throw new IllegalArgumentException(String.format("Unsupported number type: %s(%s)", number.getClass().getSimpleName(), number));
    }

    public static Number sortableBytesToNumber(byte[] bytes, Class<?> clazz) {
        assert (NumericUtil.isNumber(clazz));
        if (clazz == Long.class) {
            return NumericUtil.bytesToLong(bytes);
        }
        if (clazz == Double.class) {
            return NumericUtil.sortableLongToDouble(NumericUtil.bytesToLong(bytes));
        }
        if (clazz == Float.class) {
            return Float.valueOf(NumericUtil.sortableIntToFloat(NumericUtil.bytesToInt(bytes)));
        }
        if (clazz == Integer.class) {
            return NumericUtil.bytesToInt(bytes);
        }
        if (clazz == Short.class) {
            return (short)NumericUtil.bytesToInt(bytes);
        }
        if (clazz == Byte.class) {
            return bytes[0];
        }
        throw new IllegalArgumentException(String.format("Unsupported number type: %s", clazz.getSimpleName()));
    }

    public static byte[] longToBytes(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }

    public static long bytesToLong(byte[] bytes) {
        assert (bytes.length == 8);
        return ByteBuffer.wrap(bytes).getLong();
    }

    public static byte[] intToBytes(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        return buffer.array();
    }

    public static int bytesToInt(byte[] bytes) {
        assert (bytes.length == 4);
        return ByteBuffer.wrap(bytes).getInt();
    }

    public static boolean isNumber(Object value) {
        if (value == null) {
            return false;
        }
        return NumericUtil.isNumber(value.getClass());
    }

    public static boolean isNumber(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz);
    }

    public static Number convertToNumber(Object value) {
        if (value == null) {
            return null;
        }
        Number number = NumericUtil.isNumber(value) ? (Number)((Number)value) : (Number)(value instanceof Date ? Long.valueOf(((Date)value).getTime()) : new BigDecimal(value.toString()));
        return number;
    }

    public static int compareNumber(Object first, Number second) {
        if (first instanceof Number && first instanceof Comparable && first.getClass().equals(second.getClass())) {
            return ((Comparable)first).compareTo(second);
        }
        Function<Object, BigDecimal> toBig = number -> {
            try {
                return new BigDecimal(number.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Can't compare between %s and %s, they must be numbers", first, second));
            }
        };
        BigDecimal n1 = toBig.apply(first);
        BigDecimal n2 = toBig.apply(second);
        return n1.compareTo(n2);
    }
}

