/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.concurrent;

import com.baidu.hugegraph.concurrent.AtomicLock;
import com.baidu.hugegraph.concurrent.KeyLock;
import com.baidu.hugegraph.concurrent.RowLock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LockGroup {
    private final String name;
    private final Map<String, Object> locksMap;

    public LockGroup(String lockGroup) {
        this.name = lockGroup;
        this.locksMap = new ConcurrentHashMap<String, Object>();
    }

    public Lock lock(String lockName) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new ReentrantLock());
        }
        return (Lock)this.locksMap.get(lockName);
    }

    public AtomicLock atomicLock(String lockName) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new AtomicLock(lockName));
        }
        return (AtomicLock)this.locksMap.get(lockName);
    }

    public ReadWriteLock readWriteLock(String lockName) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new ReentrantReadWriteLock());
        }
        return (ReadWriteLock)this.locksMap.get(lockName);
    }

    public KeyLock keyLock(String lockName) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new KeyLock());
        }
        return (KeyLock)this.locksMap.get(lockName);
    }

    public KeyLock keyLock(String lockName, int size) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new KeyLock(size));
        }
        return (KeyLock)this.locksMap.get(lockName);
    }

    public RowLock rowLock(String lockName) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new RowLock());
        }
        return (RowLock)this.locksMap.get(lockName);
    }

    public String name() {
        return this.name;
    }
}

