/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.concurrent;

import com.baidu.hugegraph.util.E;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RowLock<K extends Comparable<K>> {
    private final Map<K, Lock> locks = new ConcurrentHashMap<K, Lock>();
    private final ThreadLocal<Map<K, LocalLock>> localLocks = ThreadLocal.withInitial(HashMap::new);

    public void lock(K key) {
        if (key == null) {
            return;
        }
        LocalLock localLock = this.localLocks.get().get(key);
        if (localLock != null) {
            localLock.lockCount++;
        } else {
            Lock current = new ReentrantLock();
            Lock previous = this.locks.putIfAbsent(key, current);
            if (previous != null) {
                current = previous;
            }
            current.lock();
            this.localLocks.get().put(key, new LocalLock(current));
        }
    }

    public void unlock(K key) {
        if (key == null) {
            return;
        }
        LocalLock localLock = this.localLocks.get().get(key);
        if (localLock == null) {
            return;
        }
        if (--localLock.lockCount == 0) {
            this.locks.remove(key, localLock.current);
            this.localLocks.get().remove(key);
            localLock.current.unlock();
        }
        E.checkState(localLock.lockCount >= 0, "The lock count must be >= 0, but got %s", localLock.lockCount);
    }

    public void lockAll(Set<K> keys) {
        if (keys == null) {
            return;
        }
        ArrayList<K> list = new ArrayList<K>(keys);
        Collections.sort(list);
        for (Comparable key : list) {
            this.lock(key);
        }
    }

    public void unlockAll(Set<K> keys) {
        if (keys == null) {
            return;
        }
        for (Comparable key : keys) {
            this.unlock(key);
        }
    }

    private static class LocalLock {
        private final Lock current;
        private int lockCount;

        private LocalLock(Lock current) {
            this.current = current;
            this.lockCount = 1;
        }
    }
}

